/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.line;

import java.io.IOException;
import java.io.Reader;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.line.DefaultLine;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.line.LineReader;

public class DefaultLineReader
implements LineReader {
    private final Reader reader;
    private int lineNumber;

    public DefaultLineReader(Reader reader) {
        this.reader = new BufferedCharReader(reader);
    }

    @Override
    public Line readLine() {
        ++this.lineNumber;
        try {
            int c;
            StringBuilder line = new StringBuilder();
            while ((c = this.reader.read()) != -1) {
                char ch = (char)c;
                line.append(ch);
                if (ch != '\n') continue;
                break;
            }
            if (line.length() == 0) {
                return null;
            }
            return new DefaultLine(this.lineNumber, line.toString());
        }
        catch (IOException e) {
            throw new FlywayException("Unable to read line " + this.lineNumber + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static class BufferedCharReader
    extends Reader {
        private final Reader r;
        private final char[] buffer = new char[16384];
        private boolean end;
        private int max = 0;
        private int pos = 0;

        private BufferedCharReader(Reader r) {
            this.r = r;
        }

        @Override
        public int read() throws IOException {
            if (this.pos < this.max) {
                return this.buffer[this.pos++];
            }
            if (this.end) {
                return -1;
            }
            this.max = this.r.read(this.buffer);
            if (this.max <= 0) {
                this.end = true;
                return -1;
            }
            this.pos = 0;
            return this.buffer[this.pos++];
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.r.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.r.close();
        }
    }
}

