/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.spring;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.executor.Context;
import org.flywaydb.core.api.executor.MigrationExecutor;
import org.flywaydb.core.api.migration.spring.SpringJdbcMigration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class SpringJdbcMigrationExecutor
implements MigrationExecutor {
    private final SpringJdbcMigration springJdbcMigration;

    SpringJdbcMigrationExecutor(SpringJdbcMigration springJdbcMigration) {
        this.springJdbcMigration = springJdbcMigration;
    }

    @Override
    public void execute(Context context) throws SQLException {
        try {
            this.springJdbcMigration.migrate(new JdbcTemplate((DataSource)new SingleConnectionDataSource(context.getConnection(), true)));
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FlywayException("Migration failed !", e);
        }
    }

    @Override
    public boolean canExecuteInTransaction() {
        return true;
    }
}

