/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.jdbc.JdbcUtils;

public enum DatabaseType {
    COCKROACHDB(0),
    DB2(12),
    DERBY(12),
    H2(12),
    HSQLDB(12),
    INFORMIX(12),
    MYSQL(12),
    ORACLE(12),
    POSTGRESQL(0),
    REDSHIFT(12),
    SQLITE(12),
    SQLSERVER(12),
    SYBASEASE_JTDS(0),
    SYBASEASE_JCONNECT(12),
    SAPHANA(12);

    private final int nullType;

    private DatabaseType(int nullType) {
        this.nullType = nullType;
    }

    public static DatabaseType fromJdbcConnection(Connection connection) {
        DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData(connection);
        String databaseProductName = JdbcUtils.getDatabaseProductName(databaseMetaData);
        String postgreSQLVersion = databaseProductName.startsWith("PostgreSQL") ? DatabaseType.getPostgreSQLVersion(connection) : "";
        return DatabaseType.fromDatabaseProductNameAndPostgreSQLVersion(databaseProductName, postgreSQLVersion);
    }

    private static DatabaseType fromDatabaseProductNameAndPostgreSQLVersion(String databaseProductName, String postgreSQLVersion) {
        if (databaseProductName.startsWith("Apache Derby")) {
            return DERBY;
        }
        if (databaseProductName.startsWith("SQLite")) {
            return SQLITE;
        }
        if (databaseProductName.startsWith("H2")) {
            return H2;
        }
        if (databaseProductName.contains("HSQL Database Engine")) {
            return HSQLDB;
        }
        if (databaseProductName.startsWith("Microsoft SQL Server")) {
            return SQLSERVER;
        }
        if (databaseProductName.contains("MySQL")) {
            return MYSQL;
        }
        if (databaseProductName.startsWith("Oracle")) {
            return ORACLE;
        }
        if (databaseProductName.startsWith("PostgreSQL 8") && postgreSQLVersion.contains("Redshift")) {
            return REDSHIFT;
        }
        if (databaseProductName.startsWith("PostgreSQL")) {
            if (postgreSQLVersion.contains("CockroachDB")) {
                return COCKROACHDB;
            }
            return POSTGRESQL;
        }
        if (databaseProductName.startsWith("DB2")) {
            return DB2;
        }
        if (databaseProductName.startsWith("ASE")) {
            return SYBASEASE_JTDS;
        }
        if (databaseProductName.startsWith("Adaptive Server Enterprise")) {
            return SYBASEASE_JCONNECT;
        }
        if (databaseProductName.startsWith("HDB")) {
            return SAPHANA;
        }
        if (databaseProductName.startsWith("Informix")) {
            return INFORMIX;
        }
        throw new FlywayException("Unsupported Database: " + databaseProductName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPostgreSQLVersion(Connection connection) {
        String result;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement("SELECT version()");
            resultSet = statement.executeQuery();
            result = null;
            if (resultSet.next()) {
                result = resultSet.getString(1);
            }
        }
        catch (SQLException e) {
            String string;
            try {
                string = "";
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(resultSet);
                JdbcUtils.closeStatement(statement);
                throw throwable;
            }
            JdbcUtils.closeResultSet(resultSet);
            JdbcUtils.closeStatement(statement);
            return string;
        }
        JdbcUtils.closeResultSet(resultSet);
        JdbcUtils.closeStatement(statement);
        return result;
    }

    public int getNullType() {
        return this.nullType;
    }
}

