/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.base;

import java.io.Closeable;
import java.nio.charset.Charset;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.license.FlywayEnterpriseUpgradeRequiredException;
import org.flywaydb.core.internal.placeholder.DefaultPlaceholderReplacer;
import org.flywaydb.core.internal.placeholder.NoopPlaceholderReplacer;
import org.flywaydb.core.internal.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.StringResource;
import org.flywaydb.core.internal.resource.classpath.ClassPathResource;
import org.flywaydb.core.internal.sqlscript.DefaultSqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;

public abstract class Database<C extends Connection>
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Database.class);
    protected final Configuration configuration;
    protected final DatabaseMetaData jdbcMetaData;
    private final java.sql.Connection mainJdbcConnection;
    protected final boolean originalAutoCommit;
    private C mainConnection;
    private C migrationConnection;
    private final MigrationVersion version;

    public Database(Configuration configuration, java.sql.Connection connection, boolean originalAutoCommit) {
        this.configuration = configuration;
        this.mainJdbcConnection = connection;
        this.originalAutoCommit = originalAutoCommit;
        try {
            this.jdbcMetaData = connection.getMetaData();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to get metadata for connection", e);
        }
        this.version = this.determineVersion();
    }

    protected abstract C getConnection(java.sql.Connection var1);

    public abstract void ensureSupported();

    public final MigrationVersion getVersion() {
        return this.version;
    }

    protected final void ensureDatabaseIsRecentEnough(String database, String oldestSupportedVersion) {
        if (!this.version.isAtLeast(oldestSupportedVersion)) {
            throw new FlywayDbUpgradeRequiredException(database, this.computeVersionDisplayName(this.version), this.computeVersionDisplayName(MigrationVersion.fromVersion(oldestSupportedVersion)));
        }
    }

    protected final void ensureDatabaseIsCompatibleWithFlywayEdition(String vendor, String database, String oldestSupportedVersion) {
        if (!this.version.isAtLeast(oldestSupportedVersion)) {
            throw new FlywayEnterpriseUpgradeRequiredException(vendor, database, this.computeVersionDisplayName(this.version));
        }
    }

    protected final void recommendFlywayUpgradeIfNecessary(String database, String newestSupportedVersion) {
        if (this.version.isNewerThan(newestSupportedVersion)) {
            LOG.warn("Flyway upgrade recommended: " + database + " " + this.computeVersionDisplayName(this.version) + " is newer than this version of Flyway and support has not been tested.");
        }
    }

    protected String computeVersionDisplayName(MigrationVersion version) {
        return version.getVersion();
    }

    public final SqlStatementBuilderFactory createSqlStatementBuilderFactory() {
        return this.createSqlStatementBuilderFactory(this.createPlaceholderReplacer(this.configuration.isPlaceholderReplacement(), this.configuration.getPlaceholders(), this.configuration.getPlaceholderPrefix(), this.configuration.getPlaceholderSuffix()));
    }

    protected abstract SqlStatementBuilderFactory createSqlStatementBuilderFactory(PlaceholderReplacer var1);

    public SqlScriptExecutor createSqlScriptExecutor(JdbcTemplate jdbcTemplate) {
        return new DefaultSqlScriptExecutor(jdbcTemplate);
    }

    protected PlaceholderReplacer createPlaceholderReplacer(boolean enabled, Map<String, String> placeholders, String placeholderPrefix, String placeholderSuffix) {
        if (enabled) {
            return new DefaultPlaceholderReplacer(placeholders, placeholderPrefix, placeholderSuffix);
        }
        return NoopPlaceholderReplacer.INSTANCE;
    }

    public Delimiter getDefaultDelimiter() {
        return Delimiter.SEMICOLON;
    }

    public abstract String getDbName();

    public final String getCurrentUser() {
        try {
            return this.doGetCurrentUser();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error retrieving the database user", e);
        }
    }

    protected String doGetCurrentUser() throws SQLException {
        return this.jdbcMetaData.getUserName();
    }

    public abstract boolean supportsDdlTransactions();

    public abstract boolean supportsChangingCurrentSchema();

    public abstract String getBooleanTrue();

    public abstract String getBooleanFalse();

    public final String quote(String ... identifiers) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String identifier : identifiers) {
            if (!first) {
                result.append(".");
            }
            first = false;
            result.append(this.doQuote(identifier));
        }
        return result.toString();
    }

    protected abstract String doQuote(String var1);

    public abstract boolean catalogIsSchema();

    public boolean useSingleConnection() {
        return false;
    }

    public DatabaseMetaData getJdbcMetaData() {
        return this.jdbcMetaData;
    }

    public final C getMainConnection() {
        if (this.mainConnection == null) {
            this.initConnection(this, this.mainJdbcConnection, this.configuration.getInitSql());
            this.mainConnection = this.getConnection(this.mainJdbcConnection);
        }
        return this.mainConnection;
    }

    public final C getMigrationConnection() {
        if (this.migrationConnection == null) {
            if (this.useSingleConnection()) {
                this.migrationConnection = this.mainConnection;
            } else {
                java.sql.Connection migrationJdbcConnection = JdbcUtils.openConnection(this.configuration.getDataSource(), this.configuration.getConnectRetries());
                this.initConnection(this, migrationJdbcConnection, this.configuration.getInitSql());
                this.migrationConnection = this.getConnection(migrationJdbcConnection);
            }
        }
        return this.migrationConnection;
    }

    private void initConnection(Database database, java.sql.Connection connection, String initSql) {
        if (initSql == null) {
            return;
        }
        new DefaultSqlScriptExecutor(new JdbcTemplate(connection)).execute(new SqlScript(database.createSqlStatementBuilderFactory(), new StringResource(initSql), true));
    }

    protected MigrationVersion determineVersion() {
        try {
            return MigrationVersion.fromVersion(this.jdbcMetaData.getDatabaseMajorVersion() + "." + this.jdbcMetaData.getDatabaseMinorVersion());
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine the major version of the database", e);
        }
    }

    public final SqlScript getCreateScript(Table table) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("schema", table.getSchema().getName());
        placeholders.put("table", table.getName());
        placeholders.put("table_quoted", table.toString());
        PlaceholderReplacer placeholderReplacer = this.createPlaceholderReplacer(true, placeholders, "${", "}");
        SqlStatementBuilderFactory sqlStatementBuilderFactory = this.createSqlStatementBuilderFactory(placeholderReplacer);
        return new SqlScript(sqlStatementBuilderFactory, this.getRawCreateScript(), false);
    }

    protected LoadableResource getRawCreateScript() {
        String resourceName = "org/flywaydb/core/internal/database/" + this.getDbName() + "/createMetaDataTable.sql";
        return new ClassPathResource(null, resourceName, this.getClass().getClassLoader(), Charset.forName("UTF-8"));
    }

    public String getInsertStatement(Table table) {
        return "INSERT INTO " + table + " (" + this.quote("installed_rank") + "," + this.quote("version") + "," + this.quote("description") + "," + this.quote("type") + "," + this.quote("script") + "," + this.quote("checksum") + "," + this.quote("installed_by") + "," + this.quote("execution_time") + "," + this.quote("success") + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    public String getSelectStatement(Table table, int maxCachedInstalledRank) {
        return "SELECT " + this.quote("installed_rank") + "," + this.quote("version") + "," + this.quote("description") + "," + this.quote("type") + "," + this.quote("script") + "," + this.quote("checksum") + "," + this.quote("installed_on") + "," + this.quote("installed_by") + "," + this.quote("execution_time") + "," + this.quote("success") + " FROM " + table + " WHERE " + this.quote("installed_rank") + " > " + maxCachedInstalledRank + " ORDER BY " + this.quote("installed_rank");
    }

    @Override
    public void close() {
        if (!this.useSingleConnection() && this.migrationConnection != null) {
            ((Connection)this.migrationConnection).close();
        }
        if (this.mainConnection != null) {
            ((Connection)this.mainConnection).close();
        }
    }
}

