/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.flywaydb.core.api.FlywayException;

public final class MigrationVersion
implements Comparable<MigrationVersion> {
    public static final MigrationVersion EMPTY = new MigrationVersion(null, "<< Empty Schema >>");
    public static final MigrationVersion LATEST = new MigrationVersion(BigInteger.valueOf(-1L), "<< Latest Version >>");
    public static final MigrationVersion CURRENT = new MigrationVersion(BigInteger.valueOf(-2L), "<< Current Version >>");
    private static Pattern splitPattern = Pattern.compile("\\.(?=\\d)");
    private final List<BigInteger> versionParts;
    private final String displayText;

    public static MigrationVersion fromVersion(String version) {
        if ("current".equalsIgnoreCase(version)) {
            return CURRENT;
        }
        if (LATEST.getVersion().equals(version)) {
            return LATEST;
        }
        if (version == null) {
            return EMPTY;
        }
        return new MigrationVersion(version);
    }

    private MigrationVersion(String version) {
        String normalizedVersion = version.replace('_', '.');
        this.versionParts = this.tokenize(normalizedVersion);
        this.displayText = normalizedVersion;
    }

    private MigrationVersion(BigInteger version, String displayText) {
        this.versionParts = new ArrayList<BigInteger>();
        this.versionParts.add(version);
        this.displayText = displayText;
    }

    public String toString() {
        return this.displayText;
    }

    public String getVersion() {
        if (this.equals(EMPTY)) {
            return null;
        }
        if (this.equals(LATEST)) {
            return Long.toString(Long.MAX_VALUE);
        }
        return this.displayText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationVersion version1 = (MigrationVersion)o;
        return this.compareTo(version1) == 0;
    }

    public int hashCode() {
        return this.versionParts == null ? 0 : this.versionParts.hashCode();
    }

    public boolean isAtLeast(String otherVersion) {
        return this.compareTo(MigrationVersion.fromVersion(otherVersion)) >= 0;
    }

    public boolean isNewerThan(String otherVersion) {
        return this.compareTo(MigrationVersion.fromVersion(otherVersion)) > 0;
    }

    public String getMajorAsString() {
        return this.versionParts.get(0).toString();
    }

    public String getMinorAsString() {
        if (this.versionParts.size() == 1) {
            return "0";
        }
        return this.versionParts.get(1).toString();
    }

    @Override
    public int compareTo(MigrationVersion o) {
        if (o == null) {
            return 1;
        }
        if (this == EMPTY) {
            return o == EMPTY ? 0 : Integer.MIN_VALUE;
        }
        if (this == CURRENT) {
            return o == CURRENT ? 0 : Integer.MIN_VALUE;
        }
        if (this == LATEST) {
            return o == LATEST ? 0 : Integer.MAX_VALUE;
        }
        if (o == EMPTY) {
            return Integer.MAX_VALUE;
        }
        if (o == CURRENT) {
            return Integer.MAX_VALUE;
        }
        if (o == LATEST) {
            return Integer.MIN_VALUE;
        }
        List<BigInteger> parts1 = this.versionParts;
        List<BigInteger> parts2 = o.versionParts;
        int largestNumberOfParts = Math.max(parts1.size(), parts2.size());
        for (int i = 0; i < largestNumberOfParts; ++i) {
            int compared = this.getOrZero(parts1, i).compareTo(this.getOrZero(parts2, i));
            if (compared == 0) continue;
            return compared;
        }
        return 0;
    }

    private BigInteger getOrZero(List<BigInteger> elements, int i) {
        return i < elements.size() ? elements.get(i) : BigInteger.ZERO;
    }

    private List<BigInteger> tokenize(String str) {
        ArrayList<BigInteger> parts = new ArrayList<BigInteger>();
        try {
            for (String part : splitPattern.split(str)) {
                parts.add(new BigInteger(part));
            }
        }
        catch (NumberFormatException e) {
            throw new FlywayException("Invalid version containing non-numeric characters. Only 0..9 and . are allowed. Invalid version: " + str);
        }
        for (int i = parts.size() - 1; i > 0 && ((BigInteger)parts.get(i)).equals(BigInteger.ZERO); --i) {
            parts.remove(i);
        }
        return parts;
    }
}

