/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resource.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.internal.line.DefaultLineReader;
import org.flywaydb.core.internal.line.LineReader;
import org.flywaydb.core.internal.resource.AbstractLoadableResource;
import org.flywaydb.core.internal.util.BomStrippingReader;
import org.flywaydb.core.internal.util.FileCopyUtils;

public class ClassPathResource
extends AbstractLoadableResource
implements Comparable<ClassPathResource> {
    private final String fileNameWithAbsolutePath;
    private final String fileNameWithRelativePath;
    private final ClassLoader classLoader;
    private final Charset encoding;

    public ClassPathResource(Location location, String fileNameWithAbsolutePath, ClassLoader classLoader, Charset encoding) {
        this.fileNameWithAbsolutePath = fileNameWithAbsolutePath;
        this.fileNameWithRelativePath = location == null || location.getPath().isEmpty() ? fileNameWithAbsolutePath : fileNameWithAbsolutePath.substring(location.getPath().length() + 1);
        this.classLoader = classLoader;
        this.encoding = encoding;
    }

    @Override
    public String getRelativePath() {
        return this.fileNameWithRelativePath;
    }

    @Override
    public String getAbsolutePath() {
        return this.fileNameWithAbsolutePath;
    }

    @Override
    public String getAbsolutePathOnDisk() {
        URL url = this.getUrl();
        if (url == null) {
            throw new FlywayException("Unable to fileNameWithAbsolutePath resource on disk: " + this.fileNameWithAbsolutePath);
        }
        try {
            return new File(URLDecoder.decode(url.getPath(), "UTF-8")).getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            throw new FlywayException("Unknown encoding: UTF-8", e);
        }
    }

    private URL getUrl() {
        return this.classLoader.getResource(this.fileNameWithAbsolutePath);
    }

    @Override
    public LineReader loadAsString() {
        try {
            InputStream inputStream = this.classLoader.getResourceAsStream(this.fileNameWithAbsolutePath);
            if (inputStream == null) {
                throw new FlywayException("Unable to obtain inputstream for resource: " + this.fileNameWithAbsolutePath);
            }
            return new DefaultLineReader(new BomStrippingReader(new InputStreamReader(inputStream, this.encoding)));
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load resource: " + this.fileNameWithAbsolutePath + " (encoding: " + this.encoding + ")", e);
        }
    }

    @Override
    public byte[] loadAsBytes() {
        try {
            InputStream inputStream = this.classLoader.getResourceAsStream(this.fileNameWithAbsolutePath);
            if (inputStream == null) {
                throw new FlywayException("Unable to obtain inputstream for resource: " + this.fileNameWithAbsolutePath);
            }
            return FileCopyUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load resource: " + this.fileNameWithAbsolutePath, e);
        }
    }

    @Override
    public String getFilename() {
        return this.fileNameWithAbsolutePath.substring(this.fileNameWithAbsolutePath.lastIndexOf("/") + 1);
    }

    public boolean exists() {
        return this.getUrl() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassPathResource that = (ClassPathResource)o;
        return this.fileNameWithAbsolutePath.equals(that.fileNameWithAbsolutePath);
    }

    public int hashCode() {
        return this.fileNameWithAbsolutePath.hashCode();
    }

    @Override
    public int compareTo(ClassPathResource o) {
        return this.fileNameWithAbsolutePath.compareTo(o.fileNameWithAbsolutePath);
    }
}

