/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver;

import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public class MigrationInfoHelper {
    private MigrationInfoHelper() {
    }

    public static Pair<MigrationVersion, String> extractVersionAndDescription(String migrationName, String prefix, String separator, String[] suffixes, boolean repeatable) {
        String cleanMigrationName = MigrationInfoHelper.cleanMigrationName(migrationName, prefix, suffixes);
        int descriptionPos = cleanMigrationName.indexOf(separator);
        if (descriptionPos < 0) {
            throw new FlywayException("Wrong migration name format: " + migrationName + "(It should look like this: " + prefix + (repeatable ? "" : "1.2") + separator + "Description" + suffixes[0] + ")");
        }
        String version = cleanMigrationName.substring(0, descriptionPos);
        String description = cleanMigrationName.substring(descriptionPos + separator.length()).replace("_", " ");
        if (StringUtils.hasText(version)) {
            if (repeatable) {
                throw new FlywayException("Wrong repeatable migration name format: " + migrationName + "(It cannot contain a version and should look like this: " + prefix + separator + description + suffixes[0] + ")");
            }
            return Pair.of(MigrationVersion.fromVersion(version), description);
        }
        if (!repeatable) {
            throw new FlywayException("Wrong versioned migration name format: " + migrationName + "(It must contain a version and should look like this: " + prefix + "1.2" + separator + description + suffixes[0] + ")");
        }
        return Pair.of(null, description);
    }

    private static String cleanMigrationName(String migrationName, String prefix, String[] suffixes) {
        for (String suffix : suffixes) {
            if (!migrationName.endsWith(suffix)) continue;
            return migrationName.substring(StringUtils.hasLength(prefix) ? prefix.length() : 0, migrationName.length() - suffix.length());
        }
        return migrationName;
    }
}

