/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.StringUtils;

public class DriverDataSource
implements DataSource {
    private static final Log LOG = LogFactory.getLog(DriverDataSource.class);
    private static final String DB2_JDBC_URL_PREFIX = "jdbc:db2:";
    private static final String DERBY_CLIENT_JDBC_URL_PREFIX = "jdbc:derby://";
    private static final String DERBY_EMBEDDED_JDBC_URL_PREFIX = "jdbc:derby:";
    private static final String MARIADB_JDBC_DRIVER = "org.mariadb.jdbc.Driver";
    private static final String MARIADB_JDBC_URL_PREFIX = "jdbc:mariadb:";
    private static final String MYSQL_JDBC_DRIVER = "com.mysql.cj.jdbc.Driver";
    private static final String MYSQL_JDBC_URL_PREFIX = "jdbc:mysql:";
    private static final String ORACLE_JDBC_URL_PREFIX = "jdbc:oracle:";
    private static final String POSTGRESQL_JDBC_URL_PREFIX = "jdbc:postgresql:";
    private static final String REDSHIFT_JDBC_URL_PREFIX = "jdbc:redshift:";
    private static final String REDSHIFT_JDBC41_DRIVER = "com.amazon.redshift.jdbc41.Driver";
    private static final String SAPHANA_JDBC_URL_PREFIX = "jdbc:sap:";
    private static final String SQLDROID_DRIVER = "org.sqldroid.SQLDroidDriver";
    private static final String SQLSERVER_JDBC_URL_PREFIX = "jdbc:sqlserver:";
    private static final String SYBASE_JDBC_URL_PREFIX = "jdbc:sybase:";
    private static final String APPLICATION_NAME = "Flyway by Boxfuse";
    private Driver driver;
    private final String url;
    private final String user;
    private final String password;
    private final Properties defaultProps;
    private final ClassLoader classLoader;
    private boolean autoCommit = true;

    public DriverDataSource(ClassLoader classLoader, String driverClass, String url, String user, String password) throws FlywayException {
        this(classLoader, driverClass, url, user, password, new Properties());
    }

    public DriverDataSource(ClassLoader classLoader, String driverClass, String url, String user, String password, Properties props) throws FlywayException {
        this.classLoader = classLoader;
        this.url = this.detectFallbackUrl(url);
        if (!StringUtils.hasLength(driverClass) && !StringUtils.hasLength(driverClass = this.detectDriverForUrl(url))) {
            throw new FlywayException("Unable to autodetect JDBC driver for url: " + url);
        }
        this.defaultProps = new Properties(props);
        this.defaultProps.putAll((Map<?, ?>)this.detectPropsForUrl(url));
        try {
            this.driver = (Driver)ClassUtils.instantiate(driverClass, classLoader);
        }
        catch (FlywayException e) {
            String backupDriverClass = this.detectBackupDriverForUrl(url);
            if (backupDriverClass == null) {
                throw new FlywayException("Unable to instantiate JDBC driver: " + driverClass + " => Check whether the jar file is present", e);
            }
            try {
                this.driver = (Driver)ClassUtils.instantiate(backupDriverClass, classLoader);
            }
            catch (Exception e1) {
                throw new FlywayException("Unable to instantiate JDBC driver: " + driverClass + " => Check whether the jar file is present", e);
            }
        }
        this.user = this.detectFallbackUser(user);
        this.password = this.detectFallbackPassword(password);
    }

    private String detectFallbackUrl(String url) {
        if (!StringUtils.hasText(url)) {
            String boxfuseDatabaseUrl = System.getenv("BOXFUSE_DATABASE_URL");
            if (StringUtils.hasText(boxfuseDatabaseUrl)) {
                return boxfuseDatabaseUrl;
            }
            throw new FlywayException("Missing required JDBC URL. Unable to create DataSource!");
        }
        if (!url.toLowerCase().startsWith("jdbc:")) {
            throw new FlywayException("Invalid JDBC URL (should start with jdbc:) : " + url);
        }
        return url;
    }

    private String detectFallbackUser(String user) {
        String boxfuseDatabaseUser;
        if (!StringUtils.hasText(user) && StringUtils.hasText(boxfuseDatabaseUser = System.getenv("BOXFUSE_DATABASE_USER"))) {
            return boxfuseDatabaseUser;
        }
        return user;
    }

    private String detectFallbackPassword(String password) {
        String boxfuseDatabasePassword;
        if (!StringUtils.hasText(password) && StringUtils.hasText(boxfuseDatabasePassword = System.getenv("BOXFUSE_DATABASE_PASSWORD"))) {
            return boxfuseDatabasePassword;
        }
        return password;
    }

    private Properties detectPropsForUrl(String url) {
        Properties result = new Properties();
        if (url.startsWith(ORACLE_JDBC_URL_PREFIX)) {
            String osUser = System.getProperty("user.name");
            result.put("v$session.osuser", osUser.substring(0, Math.min(osUser.length(), 30)));
            result.put("v$session.program", APPLICATION_NAME);
            result.put("oracle.net.keepAlive", "true");
        } else if (url.startsWith(SQLSERVER_JDBC_URL_PREFIX)) {
            result.put("applicationName", APPLICATION_NAME);
        } else if (url.startsWith(POSTGRESQL_JDBC_URL_PREFIX)) {
            result.put("ApplicationName", APPLICATION_NAME);
        } else if (url.startsWith(MYSQL_JDBC_URL_PREFIX) || url.startsWith(MARIADB_JDBC_URL_PREFIX)) {
            result.put("connectionAttributes", "program_name:Flyway by Boxfuse");
        } else if (url.startsWith(DB2_JDBC_URL_PREFIX)) {
            result.put("clientProgramName", APPLICATION_NAME);
            result.put("retrieveMessagesFromServerOnGetMessage", "true");
        } else if (url.startsWith(SYBASE_JDBC_URL_PREFIX)) {
            result.put("APPLICATIONNAME", APPLICATION_NAME);
        } else if (url.startsWith(SAPHANA_JDBC_URL_PREFIX)) {
            result.put("SESSIONVARIABLE:APPLICATION", APPLICATION_NAME);
        }
        return result;
    }

    private String detectBackupDriverForUrl(String url) {
        if (url.startsWith(MYSQL_JDBC_URL_PREFIX) && ClassUtils.isPresent(MARIADB_JDBC_DRIVER, this.classLoader)) {
            LOG.warn("You are attempting to connect to a MySQL database using the MariaDB driver. This is known to cause issues. An upgrade to Oracle's MySQL JDBC driver is highly recommended.");
            return MARIADB_JDBC_DRIVER;
        }
        if (url.startsWith(REDSHIFT_JDBC_URL_PREFIX)) {
            if (ClassUtils.isPresent(REDSHIFT_JDBC41_DRIVER, this.classLoader)) {
                return REDSHIFT_JDBC41_DRIVER;
            }
            return "com.amazon.redshift.jdbc4.Driver";
        }
        return null;
    }

    private String detectDriverForUrl(String url) {
        if (url.startsWith("jdbc:tc:")) {
            return "org.testcontainers.jdbc.ContainerDatabaseDriver";
        }
        if (url.startsWith(DB2_JDBC_URL_PREFIX)) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
        if (url.startsWith(DERBY_CLIENT_JDBC_URL_PREFIX)) {
            return "org.apache.derby.jdbc.ClientDriver";
        }
        if (url.startsWith(DERBY_EMBEDDED_JDBC_URL_PREFIX)) {
            return "org.apache.derby.jdbc.EmbeddedDriver";
        }
        if (url.startsWith("jdbc:h2:")) {
            return "org.h2.Driver";
        }
        if (url.startsWith("jdbc:hsqldb:")) {
            return "org.hsqldb.jdbcDriver";
        }
        if (url.startsWith("jdbc:sqlite:")) {
            if (new FeatureDetector(this.classLoader).isAndroidAvailable()) {
                return SQLDROID_DRIVER;
            }
            return "org.sqlite.JDBC";
        }
        if (url.startsWith("jdbc:sqldroid:")) {
            return SQLDROID_DRIVER;
        }
        if (url.startsWith(MYSQL_JDBC_URL_PREFIX)) {
            return MYSQL_JDBC_DRIVER;
        }
        if (url.startsWith(MARIADB_JDBC_URL_PREFIX)) {
            return MARIADB_JDBC_DRIVER;
        }
        if (url.startsWith("jdbc:google:")) {
            return "com.mysql.jdbc.GoogleDriver";
        }
        if (url.startsWith(ORACLE_JDBC_URL_PREFIX)) {
            return "oracle.jdbc.OracleDriver";
        }
        if (url.startsWith(POSTGRESQL_JDBC_URL_PREFIX)) {
            return "org.postgresql.Driver";
        }
        if (url.startsWith(REDSHIFT_JDBC_URL_PREFIX)) {
            return "com.amazon.redshift.jdbc42.Driver";
        }
        if (url.startsWith("jdbc:jtds:")) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        if (url.startsWith(SYBASE_JDBC_URL_PREFIX)) {
            return "com.sybase.jdbc4.jdbc.SybDriver";
        }
        if (url.startsWith(SQLSERVER_JDBC_URL_PREFIX)) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (url.startsWith(SAPHANA_JDBC_URL_PREFIX)) {
            return "com.sap.db.jdbc.Driver";
        }
        if (url.startsWith("jdbc:informix-sqli:")) {
            return "com.informix.jdbc.IfxDriver";
        }
        return null;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnectionFromDriver(this.getUser(), this.getPassword());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnectionFromDriver(username, password);
    }

    protected Connection getConnectionFromDriver(String username, String password) throws SQLException {
        Properties props = new Properties(this.defaultProps);
        if (username != null) {
            props.setProperty("user", username);
        }
        if (password != null) {
            props.setProperty("password", password);
        }
        Connection connection = this.driver.connect(this.url, props);
        connection.setAutoCommit(this.autoCommit);
        return connection;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public void setLoginTimeout(int timeout) {
        throw new UnsupportedOperationException("setLoginTimeout");
    }

    @Override
    public PrintWriter getLogWriter() {
        throw new UnsupportedOperationException("getLogWriter");
    }

    @Override
    public void setLogWriter(PrintWriter pw) {
        throw new UnsupportedOperationException("setLogWriter");
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        throw new UnsupportedOperationException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return DataSource.class.equals(iface);
    }

    @Override
    public Logger getParentLogger() {
        throw new UnsupportedOperationException("getParentLogger");
    }

    public void shutdownDatabase() {
        if (this.url.startsWith(DERBY_EMBEDDED_JDBC_URL_PREFIX) && !this.url.startsWith(DERBY_CLIENT_JDBC_URL_PREFIX)) {
            try {
                int i = this.url.indexOf(";");
                String shutdownUrl = (i < 0 ? this.url : this.url.substring(0, i)) + ";shutdown=true";
                this.driver.connect(shutdownUrl, new Properties());
            }
            catch (SQLException e) {
                LOG.debug("Expected error on Derby Embedded Database shutdown: " + e.getMessage());
            }
        }
    }
}

