/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.postgresql;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLCopyStatement;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;

public class PostgreSQLSqlStatementBuilder
extends SqlStatementBuilder {
    static final Pattern DOLLAR_QUOTE_REGEX = Pattern.compile("(\\$[A-Za-z0-9_]*\\$).*");
    private static final Pattern CREATE_DATABASE_TABLESPACE_SUBSCRIPTION_REGEX = Pattern.compile("^(CREATE|DROP) (DATABASE|TABLESPACE|SUBSCRIPTION) .*");
    private static final Pattern ALTER_SYSTEM_REGEX = Pattern.compile("^ALTER SYSTEM .*");
    private static final Pattern CREATE_INDEX_CONCURRENTLY_REGEX = Pattern.compile("^(CREATE|DROP)( UNIQUE)? INDEX CONCURRENTLY .*");
    private static final Pattern REINDEX_REGEX = Pattern.compile("^REINDEX( VERBOSE)? (SCHEMA|DATABASE|SYSTEM) .*");
    private static final Pattern VACUUM_REGEX = Pattern.compile("^VACUUM .*");
    private static final Pattern DISCARD_ALL_REGEX = Pattern.compile("^DISCARD ALL .*");
    private static final Pattern ALTER_TYPE_ADD_VALUE_REGEX = Pattern.compile("^ALTER TYPE .* ADD VALUE .*");
    private static final Pattern COPY_REGEX = Pattern.compile("^COPY|COPY\\s.*");
    private static final Pattern CREATE_RULE_FULL_REGEX = Pattern.compile("^CREATE( OR REPLACE)? RULE .* DO (ALSO|INSTEAD) \\(.*;(\\s*)\\);\\s?");
    private static final Pattern CREATE_RULE_PARTIAL_REGEX = Pattern.compile("^CREATE( OR REPLACE)? RULE .* DO (ALSO|INSTEAD) \\(.*");
    private String copyStatement;
    private boolean pgCopy;
    private String statementStart = "";

    public PostgreSQLSqlStatementBuilder() {
        super(Delimiter.SEMICOLON);
    }

    @Override
    public SqlStatement getSqlStatement() {
        if (this.pgCopy) {
            return new PostgreSQLCopyStatement(this.lines.subList(this.firstNonCommentLine, this.lines.size()));
        }
        return super.getSqlStatement();
    }

    @Override
    protected void applyStateChanges(String line) {
        if (this.pgCopy) {
            return;
        }
        super.applyStateChanges(line);
        if (!this.executeInTransaction || !this.hasNonCommentPart()) {
            return;
        }
        if (StringUtils.countOccurrencesOf(this.statementStart, " ") < 100) {
            this.statementStart = this.statementStart + line;
            this.statementStart = this.statementStart + " ";
            this.statementStart = StringUtils.collapseWhitespace(this.statementStart);
        }
        if (CREATE_DATABASE_TABLESPACE_SUBSCRIPTION_REGEX.matcher(this.statementStart).matches() || ALTER_SYSTEM_REGEX.matcher(this.statementStart).matches() || CREATE_INDEX_CONCURRENTLY_REGEX.matcher(this.statementStart).matches() || REINDEX_REGEX.matcher(this.statementStart).matches() || VACUUM_REGEX.matcher(this.statementStart).matches() || DISCARD_ALL_REGEX.matcher(this.statementStart).matches() || ALTER_TYPE_ADD_VALUE_REGEX.matcher(this.statementStart).matches()) {
            this.executeInTransaction = false;
        }
    }

    @Override
    protected Collection<String> tokenizeLine(String line) {
        return StringUtils.tokenizeToStringCollection(line, " @<>;:=|(),+{}[]");
    }

    @Override
    protected String simplifyLine(String line) {
        return super.simplifyLine(line.replace("$$", " $$ "));
    }

    @Override
    protected String extractAlternateOpenQuote(String token) {
        Matcher matcher = DOLLAR_QUOTE_REGEX.matcher(token);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (this.pgCopy) {
            return PostgreSQLCopyStatement.COPY_DELIMITER;
        }
        if (COPY_REGEX.matcher(line).matches()) {
            this.copyStatement = line;
        } else if (this.copyStatement != null) {
            this.copyStatement = this.copyStatement + " " + line;
        }
        if (this.copyStatement != null && this.copyStatement.contains(" FROM STDIN")) {
            this.pgCopy = true;
            return PostgreSQLCopyStatement.COPY_DELIMITER;
        }
        if (CREATE_RULE_FULL_REGEX.matcher(this.statementStart).matches()) {
            return Delimiter.SEMICOLON;
        }
        if (CREATE_RULE_PARTIAL_REGEX.matcher(this.statementStart).matches()) {
            return null;
        }
        return delimiter;
    }

    @Override
    protected String cleanToken(String token) {
        if (token.startsWith("E'")) {
            return token.substring(token.indexOf("'"));
        }
        return token;
    }
}

