/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.errorhandler.ErrorHandler;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.callback.DefaultCallbackExecutor;
import org.flywaydb.core.internal.callback.LegacyCallback;
import org.flywaydb.core.internal.callback.SqlScriptCallbackFactory;
import org.flywaydb.core.internal.clazz.ClassProvider;
import org.flywaydb.core.internal.clazz.NoopClassProvider;
import org.flywaydb.core.internal.command.DbBaseline;
import org.flywaydb.core.internal.command.DbClean;
import org.flywaydb.core.internal.command.DbInfo;
import org.flywaydb.core.internal.command.DbMigrate;
import org.flywaydb.core.internal.command.DbRepair;
import org.flywaydb.core.internal.command.DbSchemas;
import org.flywaydb.core.internal.command.DbValidate;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.database.DatabaseFactory;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.exception.FlywayProUpgradeRequiredException;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.resource.NoopResourceProvider;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.scanner.Scanner;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.schemahistory.SchemaHistoryFactory;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;
import org.flywaydb.core.internal.util.StringUtils;

public class Flyway
implements Configuration {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private final ClassicConfiguration configuration;
    private boolean dbConnectionInfoPrinted;

    public static FluentConfiguration configure() {
        return new FluentConfiguration();
    }

    public static FluentConfiguration configure(ClassLoader classLoader) {
        return new FluentConfiguration(classLoader);
    }

    @Deprecated
    public Flyway() {
        this.configuration = new ClassicConfiguration();
    }

    @Deprecated
    public Flyway(ClassLoader classLoader) {
        this.configuration = new ClassicConfiguration(classLoader);
    }

    @Deprecated
    public Flyway(FlywayConfiguration configuration) {
        LOG.warn("The Flyway(FlywayConfiguration) constructor has been deprecated and will be removed in Flyway 6.0. Use Flyway(Configuration) instead.");
        this.configuration = new ClassicConfiguration(configuration);
    }

    public Flyway(Configuration configuration) {
        this.configuration = new ClassicConfiguration(configuration);
    }

    public Configuration getConfiguration() {
        return new ClassicConfiguration(this.configuration);
    }

    @Override
    @Deprecated
    public Location[] getLocations() {
        return this.configuration.getLocations();
    }

    @Override
    @Deprecated
    public Charset getEncoding() {
        return this.configuration.getEncoding();
    }

    @Override
    @Deprecated
    public String[] getSchemas() {
        return this.configuration.getSchemas();
    }

    @Override
    @Deprecated
    public String getTable() {
        return this.configuration.getTable();
    }

    @Override
    @Deprecated
    public MigrationVersion getTarget() {
        return this.configuration.getTarget();
    }

    @Override
    @Deprecated
    public boolean isPlaceholderReplacement() {
        return this.configuration.isPlaceholderReplacement();
    }

    @Override
    @Deprecated
    public Map<String, String> getPlaceholders() {
        return this.configuration.getPlaceholders();
    }

    @Override
    @Deprecated
    public String getPlaceholderPrefix() {
        return this.configuration.getPlaceholderPrefix();
    }

    @Override
    @Deprecated
    public String getPlaceholderSuffix() {
        return this.configuration.getPlaceholderSuffix();
    }

    @Override
    @Deprecated
    public String getSqlMigrationPrefix() {
        return this.configuration.getSqlMigrationPrefix();
    }

    @Override
    @Deprecated
    public String getRepeatableSqlMigrationPrefix() {
        return this.configuration.getRepeatableSqlMigrationPrefix();
    }

    @Override
    @Deprecated
    public String getSqlMigrationSeparator() {
        return this.configuration.getSqlMigrationSeparator();
    }

    @Deprecated
    public String getSqlMigrationSuffix() {
        LOG.warn("sqlMigrationSuffix has been deprecated and will be removed in Flyway 6.0.0. Use sqlMigrationSuffixes instead.");
        return this.configuration.getSqlMigrationSuffixes()[0];
    }

    @Override
    @Deprecated
    public String[] getSqlMigrationSuffixes() {
        return this.configuration.getSqlMigrationSuffixes();
    }

    @Override
    @Deprecated
    public boolean isIgnoreMissingMigrations() {
        return this.configuration.isIgnoreMissingMigrations();
    }

    @Override
    @Deprecated
    public boolean isIgnoreIgnoredMigrations() {
        return this.configuration.isIgnoreIgnoredMigrations();
    }

    @Override
    @Deprecated
    public boolean isIgnorePendingMigrations() {
        return this.configuration.isIgnorePendingMigrations();
    }

    @Override
    @Deprecated
    public boolean isIgnoreFutureMigrations() {
        return this.configuration.isIgnoreFutureMigrations();
    }

    @Override
    @Deprecated
    public boolean isValidateOnMigrate() {
        return this.configuration.isValidateOnMigrate();
    }

    @Override
    @Deprecated
    public boolean isCleanOnValidationError() {
        return this.configuration.isCleanOnValidationError();
    }

    @Override
    @Deprecated
    public boolean isCleanDisabled() {
        return this.configuration.isCleanDisabled();
    }

    @Override
    @Deprecated
    public MigrationVersion getBaselineVersion() {
        return this.configuration.getBaselineVersion();
    }

    @Override
    @Deprecated
    public String getBaselineDescription() {
        return this.configuration.getBaselineDescription();
    }

    @Override
    @Deprecated
    public boolean isBaselineOnMigrate() {
        return this.configuration.isBaselineOnMigrate();
    }

    @Override
    @Deprecated
    public boolean isOutOfOrder() {
        return this.configuration.isOutOfOrder();
    }

    @Override
    @Deprecated
    public MigrationResolver[] getResolvers() {
        return this.configuration.getResolvers();
    }

    @Override
    @Deprecated
    public boolean isSkipDefaultResolvers() {
        return this.configuration.isSkipDefaultResolvers();
    }

    @Override
    @Deprecated
    public DataSource getDataSource() {
        return this.configuration.getDataSource();
    }

    @Override
    @Deprecated
    public int getConnectRetries() {
        return this.configuration.getConnectRetries();
    }

    @Override
    @Deprecated
    public String getInitSql() {
        return this.configuration.getInitSql();
    }

    @Override
    @Deprecated
    public ClassLoader getClassLoader() {
        return this.configuration.getClassLoader();
    }

    @Override
    @Deprecated
    public boolean isMixed() {
        return this.configuration.isMixed();
    }

    @Override
    @Deprecated
    public String getInstalledBy() {
        return this.configuration.getInstalledBy();
    }

    @Override
    @Deprecated
    public boolean isGroup() {
        return this.configuration.isGroup();
    }

    @Override
    @Deprecated
    public ErrorHandler[] getErrorHandlers() {
        return this.configuration.getErrorHandlers();
    }

    @Override
    @Deprecated
    public String[] getErrorOverrides() {
        return this.configuration.getErrorOverrides();
    }

    @Override
    @Deprecated
    public OutputStream getDryRunOutput() {
        return this.configuration.getDryRunOutput();
    }

    @Override
    @Deprecated
    public boolean isStream() {
        return this.configuration.isStream();
    }

    @Override
    @Deprecated
    public boolean isBatch() {
        return this.configuration.isBatch();
    }

    @Override
    @Deprecated
    public boolean isOracleSqlplus() {
        return this.configuration.isOracleSqlplus();
    }

    @Override
    @Deprecated
    public String getLicenseKey() {
        return this.configuration.getLicenseKey();
    }

    @Deprecated
    public void setDryRunOutput(OutputStream dryRunOutput) {
        this.configuration.setDryRunOutput(dryRunOutput);
    }

    @Deprecated
    public void setDryRunOutputAsFile(File dryRunOutput) {
        this.configuration.setDryRunOutputAsFile(dryRunOutput);
    }

    @Deprecated
    public void setDryRunOutputAsFileName(String dryRunOutputFileName) {
        this.configuration.setDryRunOutputAsFileName(dryRunOutputFileName);
    }

    @Deprecated
    public void setErrorHandlers(ErrorHandler ... errorHandlers) {
        this.configuration.setErrorHandlers(errorHandlers);
    }

    @Deprecated
    public void setErrorHandlersAsClassNames(String ... errorHandlerClassNames) {
        this.configuration.setErrorHandlersAsClassNames(errorHandlerClassNames);
    }

    @Deprecated
    public void setErrorOverrides(String ... errorOverrides) {
        this.configuration.setErrorOverrides(errorOverrides);
    }

    @Deprecated
    public void setGroup(boolean group) {
        this.configuration.setGroup(group);
    }

    @Deprecated
    public void setInstalledBy(String installedBy) {
        this.configuration.setInstalledBy(installedBy);
    }

    @Deprecated
    public void setMixed(boolean mixed) {
        this.configuration.setMixed(mixed);
    }

    @Deprecated
    public void setIgnoreMissingMigrations(boolean ignoreMissingMigrations) {
        this.configuration.setIgnoreMissingMigrations(ignoreMissingMigrations);
    }

    @Deprecated
    public void setIgnoreIgnoredMigrations(boolean ignoreIgnoredMigrations) {
        this.configuration.setIgnoreIgnoredMigrations(ignoreIgnoredMigrations);
    }

    @Deprecated
    public void setIgnoreFutureMigrations(boolean ignoreFutureMigrations) {
        this.configuration.setIgnoreFutureMigrations(ignoreFutureMigrations);
    }

    @Deprecated
    public void setValidateOnMigrate(boolean validateOnMigrate) {
        this.configuration.setValidateOnMigrate(validateOnMigrate);
    }

    @Deprecated
    public void setCleanOnValidationError(boolean cleanOnValidationError) {
        this.configuration.setCleanOnValidationError(cleanOnValidationError);
    }

    @Deprecated
    public void setCleanDisabled(boolean cleanDisabled) {
        this.configuration.setCleanDisabled(cleanDisabled);
    }

    @Deprecated
    public void setLocations(String ... locations) {
        this.configuration.setLocationsAsStrings(locations);
    }

    @Deprecated
    public void setEncoding(String encoding) {
        this.configuration.setEncodingAsString(encoding);
    }

    @Deprecated
    public void setSchemas(String ... schemas) {
        this.configuration.setSchemas(schemas);
    }

    @Deprecated
    public void setTable(String table) {
        this.configuration.setTable(table);
    }

    @Deprecated
    public void setTarget(MigrationVersion target) {
        this.configuration.setTarget(target);
    }

    @Deprecated
    public void setTargetAsString(String target) {
        this.configuration.setTargetAsString(target);
    }

    @Deprecated
    public void setPlaceholderReplacement(boolean placeholderReplacement) {
        this.configuration.setPlaceholderReplacement(placeholderReplacement);
    }

    @Deprecated
    public void setPlaceholders(Map<String, String> placeholders) {
        this.configuration.setPlaceholders(placeholders);
    }

    @Deprecated
    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.configuration.setPlaceholderPrefix(placeholderPrefix);
    }

    @Deprecated
    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.configuration.setPlaceholderSuffix(placeholderSuffix);
    }

    @Deprecated
    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.configuration.setSqlMigrationPrefix(sqlMigrationPrefix);
    }

    @Override
    @Deprecated
    public String getUndoSqlMigrationPrefix() {
        return this.configuration.getUndoSqlMigrationPrefix();
    }

    @Deprecated
    public void setUndoSqlMigrationPrefix(String undoSqlMigrationPrefix) {
        this.configuration.setUndoSqlMigrationPrefix(undoSqlMigrationPrefix);
    }

    @Deprecated
    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        this.configuration.setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefix);
    }

    @Deprecated
    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        this.configuration.setSqlMigrationSeparator(sqlMigrationSeparator);
    }

    @Deprecated
    public void setSqlMigrationSuffix(String sqlMigrationSuffix) {
        LOG.warn("sqlMigrationSuffix has been deprecated and will be removed in Flyway 6.0.0. Use sqlMigrationSuffixes instead.");
        this.configuration.setSqlMigrationSuffixes(sqlMigrationSuffix);
    }

    @Deprecated
    public void setSqlMigrationSuffixes(String ... sqlMigrationSuffixes) {
        this.configuration.setSqlMigrationSuffixes(sqlMigrationSuffixes);
    }

    @Deprecated
    public void setDataSource(DataSource dataSource) {
        this.configuration.setDataSource(dataSource);
    }

    @Deprecated
    public void setDataSource(String url, String user, String password, String ... initSqls) {
        this.configuration.setDataSource(url, user, password, initSqls);
    }

    @Deprecated
    public void setClassLoader(ClassLoader classLoader) {
        LOG.warn("Flyway.setClassLoader() has been deprecated and will be removed in Flyway 6.0. Use {@link Flyway(ClassLoader)} instead.");
        this.configuration.setClassLoader(classLoader);
    }

    @Deprecated
    public void setBaselineVersion(MigrationVersion baselineVersion) {
        this.configuration.setBaselineVersion(baselineVersion);
    }

    @Deprecated
    public void setBaselineVersionAsString(String baselineVersion) {
        this.configuration.setBaselineVersionAsString(baselineVersion);
    }

    @Deprecated
    public void setBaselineDescription(String baselineDescription) {
        this.configuration.setBaselineDescription(baselineDescription);
    }

    @Deprecated
    public void setBaselineOnMigrate(boolean baselineOnMigrate) {
        this.configuration.setBaselineOnMigrate(baselineOnMigrate);
    }

    @Deprecated
    public void setOutOfOrder(boolean outOfOrder) {
        this.configuration.setOutOfOrder(outOfOrder);
    }

    @Override
    @Deprecated
    public Callback[] getCallbacks() {
        return this.configuration.getCallbacks();
    }

    @Override
    @Deprecated
    public boolean isSkipDefaultCallbacks() {
        return this.configuration.isSkipDefaultCallbacks();
    }

    @Deprecated
    public void setCallbacks(Callback ... callbacks) {
        this.configuration.setCallbacks(callbacks);
    }

    @Deprecated
    public void setCallbacks(FlywayCallback ... callbacks) {
        LOG.warn("Flyway.setCallbacks(FlywayCallback) has been deprecated and will be removed in Flyway 6.0. Use Flyway.setCallbacks(Callback) instead.");
        ArrayList<LegacyCallback> l = new ArrayList<LegacyCallback>();
        for (FlywayCallback callback : callbacks) {
            l.add(new LegacyCallback(callback));
        }
        this.configuration.setCallbacks(l.toArray(new Callback[0]));
    }

    @Deprecated
    public void setCallbacksAsClassNames(String ... callbacks) {
        this.configuration.setCallbacksAsClassNames(callbacks);
    }

    @Deprecated
    public void setSkipDefaultCallbacks(boolean skipDefaultCallbacks) {
        this.configuration.setSkipDefaultCallbacks(skipDefaultCallbacks);
    }

    @Deprecated
    public void setResolvers(MigrationResolver ... resolvers) {
        this.configuration.setResolvers(resolvers);
    }

    @Deprecated
    public void setResolversAsClassNames(String ... resolvers) {
        this.configuration.setResolversAsClassNames(resolvers);
    }

    @Deprecated
    public void setSkipDefaultResolvers(boolean skipDefaultResolvers) {
        this.configuration.setSkipDefaultResolvers(skipDefaultResolvers);
    }

    @Deprecated
    public void setStream(boolean stream) {
        this.configuration.setStream(stream);
    }

    @Deprecated
    public void setBatch(boolean batch) {
        this.configuration.setBatch(batch);
    }

    @Deprecated
    public void setOracleSqlplus(boolean oracleSqlplus) {
        this.configuration.setOracleSqlplus(oracleSqlplus);
    }

    @Deprecated
    public void setLicenseKey(String licenseKey) {
        this.configuration.setLicenseKey(licenseKey);
    }

    public int migrate() throws FlywayException {
        return this.execute(new Command<Integer>(){

            @Override
            public Integer execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                if (Flyway.this.configuration.isValidateOnMigrate()) {
                    Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, callbackExecutor, true);
                }
                new DbSchemas(database, schemas, schemaHistory).create();
                if (!schemaHistory.exists()) {
                    ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                    for (Schema schema : schemas) {
                        if (schema.empty()) continue;
                        nonEmptySchemas.add(schema);
                    }
                    if (!nonEmptySchemas.isEmpty()) {
                        if (Flyway.this.configuration.isBaselineOnMigrate()) {
                            Flyway.this.doBaseline(schemaHistory, database, schemas, callbackExecutor);
                        } else if (!schemaHistory.exists()) {
                            throw new FlywayException("Found non-empty schema(s) " + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + " without schema history table! Use baseline() or set baselineOnMigrate to true to initialize the schema history table.");
                        }
                    }
                }
                return new DbMigrate(database, schemaHistory, schemas[0], migrationResolver, Flyway.this.configuration, callbackExecutor).migrate();
            }
        }, true);
    }

    private void doBaseline(SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
        new DbBaseline(database, schemaHistory, schemas[0], this.configuration.getBaselineVersion(), this.configuration.getBaselineDescription(), callbackExecutor).baseline();
    }

    public int undo() throws FlywayException {
        throw new FlywayProUpgradeRequiredException("undo");
    }

    public void validate() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, callbackExecutor, Flyway.this.configuration.isIgnorePendingMigrations());
                return null;
            }
        }, true);
    }

    private void doValidate(Database database, MigrationResolver migrationResolver, SchemaHistory schemaHistory, Schema[] schemas, CallbackExecutor callbackExecutor, boolean ignorePending) {
        String validationError = new DbValidate(database, schemaHistory, schemas[0], migrationResolver, this.configuration, ignorePending, callbackExecutor).validate();
        if (validationError != null) {
            if (this.configuration.isCleanOnValidationError()) {
                this.doClean(database, schemaHistory, schemas, callbackExecutor);
            } else {
                throw new FlywayException("Validate failed: " + validationError);
            }
        }
    }

    private void doClean(Database database, SchemaHistory schemaHistory, Schema[] schemas, CallbackExecutor callbackExecutor) {
        new DbClean(database, schemaHistory, schemas, callbackExecutor, this.configuration.isCleanDisabled()).clean();
    }

    public void clean() {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                Flyway.this.doClean(database, schemaHistory, schemas, callbackExecutor);
                return null;
            }
        }, false);
    }

    public MigrationInfoService info() {
        return this.execute(new Command<MigrationInfoService>(){

            @Override
            public MigrationInfoService execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                return new DbInfo(migrationResolver, schemaHistory, Flyway.this.configuration, callbackExecutor).info();
            }
        }, true);
    }

    public void baseline() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                new DbSchemas(database, schemas, schemaHistory).create();
                Flyway.this.doBaseline(schemaHistory, database, schemas, callbackExecutor);
                return null;
            }
        }, false);
    }

    public void repair() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, CallbackExecutor callbackExecutor) {
                new DbRepair(database, migrationResolver, schemaHistory, callbackExecutor, Flyway.this.configuration).repair();
                return null;
            }
        }, true);
    }

    private MigrationResolver createMigrationResolver(Database database, ResourceProvider resourceProvider, ClassProvider classProvider, SqlStatementBuilderFactory sqlStatementBuilderFactory) {
        for (MigrationResolver resolver : this.configuration.getResolvers()) {
            ConfigUtils.injectFlywayConfiguration(resolver, this.configuration);
        }
        return new CompositeMigrationResolver(database, resourceProvider, classProvider, this.configuration, sqlStatementBuilderFactory, this.configuration.getResolvers());
    }

    @Deprecated
    public void configure(Properties properties) {
        this.configure(ConfigUtils.propertiesToMap(properties));
    }

    @Deprecated
    public void configure(Map<String, String> props) {
        this.configuration.configure(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(Command<T> command, boolean scannerRequired) {
        T result;
        VersionPrinter.printVersion();
        if (this.configuration.getDataSource() == null) {
            throw new FlywayException("Unable to connect to the database. Configure the url, user and password!");
        }
        Database database = null;
        try {
            ClassProvider classProvider;
            ResourceProvider resourceProvider;
            database = DatabaseFactory.createDatabase(this.configuration, !this.dbConnectionInfoPrinted);
            this.dbConnectionInfoPrinted = true;
            LOG.debug("DDL Transactions Supported: " + database.supportsDdlTransactions());
            Schema[] schemas = this.prepareSchemas(database);
            if (!scannerRequired && this.configuration.isSkipDefaultResolvers() && this.configuration.isSkipDefaultCallbacks()) {
                resourceProvider = NoopResourceProvider.INSTANCE;
                classProvider = NoopClassProvider.INSTANCE;
            } else {
                Scanner scanner = new Scanner(Arrays.asList(this.configuration.getLocations()), this.configuration.getClassLoader(), this.configuration.getEncoding());
                resourceProvider = scanner;
                classProvider = scanner;
            }
            SqlStatementBuilderFactory sqlStatementBuilderFactory = database.createSqlStatementBuilderFactory();
            DefaultCallbackExecutor callbackExecutor = new DefaultCallbackExecutor(this.configuration, database, schemas[0], this.prepareCallbacks(database, resourceProvider, sqlStatementBuilderFactory));
            result = command.execute(this.createMigrationResolver(database, resourceProvider, classProvider, sqlStatementBuilderFactory), SchemaHistoryFactory.getSchemaHistory(this.configuration, database, schemas[0]), database, schemas, callbackExecutor);
        }
        finally {
            if (database != null) {
                database.close();
            }
            this.showMemoryUsage();
        }
        return result;
    }

    private void showMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        long used = total - free;
        long totalMB = total / 0x100000L;
        long usedMB = used / 0x100000L;
        LOG.debug("Memory usage: " + usedMB + " of " + totalMB + "M");
    }

    private Schema[] prepareSchemas(Database database) {
        Object[] schemaNames = this.configuration.getSchemas();
        if (schemaNames.length == 0) {
            Schema currentSchema = ((Connection)database.getMainConnection()).getCurrentSchema();
            if (currentSchema == null) {
                throw new FlywayException("Unable to determine schema for the schema history table. Set a default schema for the connection or specify one using the schemas property!");
            }
            schemaNames = new String[]{currentSchema.getName()};
        }
        if (schemaNames.length == 1) {
            LOG.debug("Schema: " + (String)schemaNames[0]);
        } else {
            LOG.debug("Schemas: " + StringUtils.arrayToCommaDelimitedString(schemaNames));
        }
        Schema[] schemas = new Schema[schemaNames.length];
        for (int i = 0; i < schemaNames.length; ++i) {
            schemas[i] = ((Connection)database.getMainConnection()).getSchema((String)schemaNames[i]);
        }
        return schemas;
    }

    private List<Callback> prepareCallbacks(Database database, ResourceProvider resourceProvider, SqlStatementBuilderFactory sqlStatementBuilderFactory) {
        ArrayList<Callback> effectiveCallbacks = new ArrayList<Callback>();
        effectiveCallbacks.addAll(Arrays.asList(this.configuration.getCallbacks()));
        if (!this.configuration.isSkipDefaultCallbacks()) {
            effectiveCallbacks.addAll(new SqlScriptCallbackFactory(database, resourceProvider, sqlStatementBuilderFactory, this.configuration).getCallbacks());
        }
        for (Callback callback : effectiveCallbacks) {
            if (!(callback instanceof LegacyCallback)) continue;
            ConfigUtils.injectFlywayConfiguration(callback, this.configuration);
        }
        return effectiveCallbacks;
    }

    static interface Command<T> {
        public T execute(MigrationResolver var1, SchemaHistory var2, Database var3, Schema[] var4, CallbackExecutor var5);
    }
}

