/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.saphana;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.database.Table;
import org.flywaydb.core.internal.database.saphana.SAPHANADatabase;
import org.flywaydb.core.internal.database.saphana.SAPHANATable;
import org.flywaydb.core.internal.util.jdbc.JdbcTemplate;

public class SAPHANASchema
extends Schema<SAPHANADatabase> {
    SAPHANASchema(JdbcTemplate jdbcTemplate, SAPHANADatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM SYS.SCHEMAS WHERE SCHEMA_NAME=?", this.name) > 0;
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("select count(*) from sys.tables where schema_name = ?", this.name);
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from sys.views where schema_name = ?", this.name);
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from sys.sequences where schema_name = ?", this.name);
        return (objectCount += this.jdbcTemplate.queryForInt("select count(*) from sys.synonyms where schema_name = ?", this.name)) == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((SAPHANADatabase)this.database).quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.clean();
        this.jdbcTemplate.execute("DROP SCHEMA " + ((SAPHANADatabase)this.database).quote(this.name) + " RESTRICT", new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        for (String dropStatement : this.generateDropStatements("SYNONYM")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatements("VIEW")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatements("TABLE")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
        for (String dropStatement : this.generateDropStatements("SEQUENCE")) {
            this.jdbcTemplate.execute(dropStatement, new Object[0]);
        }
    }

    private List<String> generateDropStatements(String objectType) throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        List<String> dbObjects = this.getDbObjects(objectType);
        for (String dbObject : dbObjects) {
            dropStatements.add("DROP " + objectType + " " + ((SAPHANADatabase)this.database).quote(this.name, dbObject) + " CASCADE");
        }
        return dropStatements;
    }

    private List<String> getDbObjects(String objectType) throws SQLException {
        return this.jdbcTemplate.queryForStringList("select " + objectType + "_NAME from SYS." + objectType + "S where SCHEMA_NAME = ?", this.name);
    }

    @Override
    protected Table[] doAllTables() throws SQLException {
        List<String> tableNames = this.getDbObjects("TABLE");
        Table[] tables = new Table[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new SAPHANATable(this.jdbcTemplate, this.database, this, tableNames.get(i));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new SAPHANATable(this.jdbcTemplate, this.database, this, tableName);
    }
}

