/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.scanner.classpath.android;

import android.content.res.AssetManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.BomStrippingReader;
import org.flywaydb.core.internal.util.FileCopyUtils;
import org.flywaydb.core.internal.util.line.DefaultLineReader;
import org.flywaydb.core.internal.util.line.LineReader;
import org.flywaydb.core.internal.util.scanner.AbstractLoadableResource;

public class AndroidResource
extends AbstractLoadableResource {
    private final AssetManager assetManager;
    private final String path;
    private final String name;
    private final Charset encoding;

    AndroidResource(AssetManager assetManager, String path, String name, Charset encoding) {
        this.assetManager = assetManager;
        this.path = path;
        this.name = name;
        this.encoding = encoding;
    }

    @Override
    public String getLocation() {
        return this.path + "/" + this.name;
    }

    @Override
    public String getLocationOnDisk() {
        return null;
    }

    @Override
    public LineReader loadAsString() {
        try {
            return new DefaultLineReader(new BomStrippingReader(new InputStreamReader(this.assetManager.open(this.getLocation()), this.encoding)));
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load asset: " + this.getLocation(), e);
        }
    }

    @Override
    public byte[] loadAsBytes() {
        try {
            return FileCopyUtils.copyToByteArray(this.assetManager.open(this.getLocation()));
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load asset: " + this.getLocation(), e);
        }
    }

    @Override
    public String getFilename() {
        return this.name;
    }
}

