/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database;

import java.util.List;
import java.util.Locale;
import org.flywaydb.core.internal.database.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.util.jdbc.ContextImpl;
import org.flywaydb.core.internal.util.line.Line;

public abstract class AbstractSqlStatement<C extends ContextImpl>
implements SqlStatement<C> {
    protected final List<Line> lines;
    private final Delimiter delimiter;
    private String sql;

    public AbstractSqlStatement(List<Line> lines, Delimiter delimiter) {
        this.lines = lines;
        this.delimiter = delimiter;
    }

    @Override
    public final int getLineNumber() {
        return this.lines.get(0).getLineNumber();
    }

    @Override
    public final String getSql() {
        if (this.sql == null) {
            StringBuilder sqlBuilder = new StringBuilder();
            for (Line line : this.lines) {
                sqlBuilder.append(line.getLine());
            }
            AbstractSqlStatement.stripDelimiter(sqlBuilder, this.delimiter);
            this.sql = sqlBuilder.toString();
        }
        return this.sql;
    }

    @Override
    public String getDelimiter() {
        return this.delimiter.toString();
    }

    static void stripDelimiter(StringBuilder sql, Delimiter delimiter) {
        while (Character.isWhitespace(sql.charAt(sql.length() - 1))) {
            sql.delete(sql.length() - 1, sql.length());
        }
        int length = delimiter.getDelimiter().length();
        if (length > sql.length()) {
            return;
        }
        String actualDelimiter = sql.substring(sql.length() - length, sql.length());
        if (actualDelimiter.toUpperCase(Locale.ENGLISH).equals(delimiter.getDelimiter().toUpperCase(Locale.ENGLISH))) {
            sql.delete(sql.length() - length, sql.length());
        }
    }
}

