/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import java.util.concurrent.Callable;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;

public class DbSchemas {
    private static final Log LOG = LogFactory.getLog(DbSchemas.class);
    private final Connection connection;
    private final Schema[] schemas;
    private final SchemaHistory schemaHistory;

    public DbSchemas(Database database, Schema[] schemas, SchemaHistory schemaHistory) {
        this.connection = database.getMainConnection();
        this.schemas = schemas;
        this.schemaHistory = schemaHistory;
    }

    public void create() {
        int retries = 0;
        while (true) {
            try {
                new TransactionTemplate(this.connection.getJdbcConnection()).execute(new Callable<Object>(){

                    @Override
                    public Void call() {
                        for (Schema schema : DbSchemas.this.schemas) {
                            if (!schema.exists()) continue;
                            LOG.debug("Schema " + schema + " already exists. Skipping schema creation.");
                            return null;
                        }
                        for (Schema schema : DbSchemas.this.schemas) {
                            LOG.info("Creating schema " + schema + " ...");
                            schema.create();
                        }
                        DbSchemas.this.schemaHistory.create();
                        DbSchemas.this.schemaHistory.addSchemasMarker(DbSchemas.this.schemas);
                        return null;
                    }
                });
                return;
            }
            catch (RuntimeException e) {
                if (++retries >= 10) {
                    throw e;
                }
                try {
                    LOG.debug("Schema creation failed. Retrying in 1 sec ...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }
}

