/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.callback;

import java.sql.Connection;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;

public class CallbackExecutor {
    private final Configuration configuration;
    private final Database database;
    private final Schema schema;
    private final Collection<Callback> callbacks;

    public CallbackExecutor(Configuration configuration, Database database, Schema schema, Collection<Callback> callbacks) {
        this.configuration = configuration;
        this.database = database;
        this.schema = schema;
        this.callbacks = callbacks;
    }

    public void executeOnMainConnection(Event event) {
        this.execute(event, (org.flywaydb.core.internal.database.Connection)this.database.getMainConnection());
    }

    public void executeOnMigrationConnection(Event event) {
        this.execute(event, (org.flywaydb.core.internal.database.Connection)this.database.getMigrationConnection());
    }

    public void executeOnMigrationConnection(Event event, MigrationInfo migrationInfo) {
        SimpleContext context = new SimpleContext(this.configuration, (org.flywaydb.core.internal.database.Connection)this.database.getMigrationConnection(), migrationInfo);
        for (Callback callback : this.callbacks) {
            if (!callback.supports(event, context)) continue;
            callback.handle(event, context);
        }
    }

    private void execute(final Event event, final org.flywaydb.core.internal.database.Connection connection) {
        final SimpleContext context = new SimpleContext(this.configuration, connection, null);
        for (final Callback callback : this.callbacks) {
            if (!callback.supports(event, context)) continue;
            if (callback.canHandleInTransaction(event, context)) {
                new TransactionTemplate(connection.getJdbcConnection()).execute(new Callable<Object>(){

                    @Override
                    public Object call() {
                        CallbackExecutor.this.execute(connection, callback, event, context);
                        return null;
                    }
                });
                continue;
            }
            this.execute(connection, callback, event, context);
        }
    }

    private void execute(org.flywaydb.core.internal.database.Connection connection, Callback callback, Event event, Context context) {
        connection.restoreOriginalState();
        connection.changeCurrentSchemaTo(this.schema);
        callback.handle(event, context);
    }

    private static class SimpleContext
    implements Context {
        private final Configuration configuration;
        private final org.flywaydb.core.internal.database.Connection connection;
        private final MigrationInfo migrationInfo;

        private SimpleContext(Configuration configuration, org.flywaydb.core.internal.database.Connection connection, MigrationInfo migrationInfo) {
            this.configuration = configuration;
            this.connection = connection;
            this.migrationInfo = migrationInfo;
        }

        @Override
        public Configuration getConfiguration() {
            return this.configuration;
        }

        @Override
        public Connection getConnection() {
            return this.connection.getJdbcConnection();
        }

        @Override
        public MigrationInfo getMigrationInfo() {
            return this.migrationInfo;
        }
    }
}

