/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.configuration;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.errorhandler.ErrorHandler;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.callback.LegacyCallback;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.exception.FlywayProUpgradeRequiredException;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.jdbc.DriverDataSource;

public class ClassicConfiguration
implements Configuration {
    private static final Log LOG = LogFactory.getLog(ClassicConfiguration.class);
    private String driver;
    private String url;
    private String user;
    private String password;
    private DataSource dataSource;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private Locations locations = new Locations("db/migration");
    private Charset encoding = Charset.forName("UTF-8");
    private String[] schemaNames = new String[0];
    private String table = "flyway_schema_history";
    private MigrationVersion target;
    private boolean placeholderReplacement = true;
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String sqlMigrationPrefix = "V";
    private String repeatableSqlMigrationPrefix = "R";
    private String sqlMigrationSeparator = "__";
    private String[] sqlMigrationSuffixes = new String[]{".sql"};
    private boolean ignoreMissingMigrations;
    private boolean ignoreIgnoredMigrations;
    private boolean ignoreFutureMigrations = true;
    private boolean validateOnMigrate = true;
    private boolean cleanOnValidationError;
    private boolean cleanDisabled;
    private MigrationVersion baselineVersion = MigrationVersion.fromVersion("1");
    private String baselineDescription = "<< Flyway Baseline >>";
    private boolean baselineOnMigrate;
    private boolean outOfOrder;
    private final List<Callback> callbacks = new ArrayList<Callback>();
    private boolean skipDefaultCallbacks;
    private MigrationResolver[] resolvers = new MigrationResolver[0];
    private boolean skipDefaultResolvers;
    private boolean mixed;
    private boolean group;
    private String installedBy;

    public ClassicConfiguration() {
    }

    public ClassicConfiguration(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
    }

    public ClassicConfiguration(Configuration configuration) {
        this(configuration.getClassLoader());
        this.configure(configuration);
    }

    @Override
    public Location[] getLocations() {
        return this.locations.getLocations().toArray(new Location[0]);
    }

    @Override
    public Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public String[] getSchemas() {
        return this.schemaNames;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public MigrationVersion getTarget() {
        return this.target;
    }

    @Override
    public boolean isPlaceholderReplacement() {
        return this.placeholderReplacement;
    }

    @Override
    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    @Override
    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    @Override
    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    @Override
    public String getRepeatableSqlMigrationPrefix() {
        return this.repeatableSqlMigrationPrefix;
    }

    @Override
    public String getSqlMigrationSeparator() {
        return this.sqlMigrationSeparator;
    }

    @Override
    public String[] getSqlMigrationSuffixes() {
        return this.sqlMigrationSuffixes;
    }

    @Override
    public boolean isIgnoreMissingMigrations() {
        return this.ignoreMissingMigrations;
    }

    @Override
    public boolean isIgnoreIgnoredMigrations() {
        return this.ignoreIgnoredMigrations;
    }

    @Override
    public boolean isIgnoreFutureMigrations() {
        return this.ignoreFutureMigrations;
    }

    @Override
    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    @Override
    public boolean isCleanOnValidationError() {
        return this.cleanOnValidationError;
    }

    @Override
    public boolean isCleanDisabled() {
        return this.cleanDisabled;
    }

    @Override
    public MigrationVersion getBaselineVersion() {
        return this.baselineVersion;
    }

    @Override
    public String getBaselineDescription() {
        return this.baselineDescription;
    }

    @Override
    public boolean isBaselineOnMigrate() {
        return this.baselineOnMigrate;
    }

    @Override
    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    @Override
    public MigrationResolver[] getResolvers() {
        return this.resolvers;
    }

    @Override
    public boolean isSkipDefaultResolvers() {
        return this.skipDefaultResolvers;
    }

    @Override
    public DataSource getDataSource() {
        if (this.dataSource == null && (StringUtils.hasLength(this.driver) || StringUtils.hasLength(this.user) || StringUtils.hasLength(this.password))) {
            LOG.warn("Discarding INCOMPLETE dataSource configuration! flyway.url must be set.");
        }
        return this.dataSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public boolean isMixed() {
        return this.mixed;
    }

    @Override
    public String getInstalledBy() {
        return this.installedBy;
    }

    @Override
    public boolean isGroup() {
        return this.group;
    }

    @Override
    public ErrorHandler[] getErrorHandlers() {
        throw new FlywayProUpgradeRequiredException("errorHandlers");
    }

    @Override
    public String[] getErrorOverrides() {
        throw new FlywayProUpgradeRequiredException("errorOverrides");
    }

    @Override
    public OutputStream getDryRunOutput() {
        throw new FlywayProUpgradeRequiredException("dryRunOutput");
    }

    @Deprecated
    public void setClassLoader(ClassLoader classLoader) {
        LOG.warn("setClassLoader() is deprecated and will be removed in Flyway 6.0. Use new ClassicConfiguration(ClassLoader) instead.");
        this.classLoader = classLoader;
    }

    public void setDryRunOutput(OutputStream dryRunOutput) {
        throw new FlywayProUpgradeRequiredException("dryRunOutput");
    }

    public void setDryRunOutputAsFile(File dryRunOutput) {
        throw new FlywayProUpgradeRequiredException("dryRunOutput");
    }

    public void setDryRunOutputAsFileName(String dryRunOutputFileName) {
        throw new FlywayProUpgradeRequiredException("dryRunOutput");
    }

    public void setErrorHandlers(ErrorHandler ... errorHandlers) {
        throw new FlywayProUpgradeRequiredException("errorHandlers");
    }

    public void setErrorHandlersAsClassNames(String ... errorHandlerClassNames) {
        throw new FlywayProUpgradeRequiredException("errorHandlers");
    }

    public void setErrorOverrides(String ... errorOverrides) {
        throw new FlywayProUpgradeRequiredException("errorOverrides");
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public void setInstalledBy(String installedBy) {
        if ("".equals(installedBy)) {
            installedBy = null;
        }
        this.installedBy = installedBy;
    }

    public void setMixed(boolean mixed) {
        this.mixed = mixed;
    }

    public void setIgnoreMissingMigrations(boolean ignoreMissingMigrations) {
        this.ignoreMissingMigrations = ignoreMissingMigrations;
    }

    public void setIgnoreIgnoredMigrations(boolean ignoreIgnoredMigrations) {
        this.ignoreIgnoredMigrations = ignoreIgnoredMigrations;
    }

    public void setIgnoreFutureMigrations(boolean ignoreFutureMigrations) {
        this.ignoreFutureMigrations = ignoreFutureMigrations;
    }

    public void setValidateOnMigrate(boolean validateOnMigrate) {
        this.validateOnMigrate = validateOnMigrate;
    }

    public void setCleanOnValidationError(boolean cleanOnValidationError) {
        this.cleanOnValidationError = cleanOnValidationError;
    }

    public void setCleanDisabled(boolean cleanDisabled) {
        this.cleanDisabled = cleanDisabled;
    }

    public void setLocationsAsStrings(String ... locations) {
        this.locations = new Locations(locations);
    }

    public void setLocations(Location ... locations) {
        this.locations = new Locations(Arrays.asList(locations));
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public void setEncodingAsString(String encoding) {
        this.encoding = Charset.forName(encoding);
    }

    public void setSchemas(String ... schemas) {
        this.schemaNames = schemas;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setTarget(MigrationVersion target) {
        this.target = target;
    }

    public void setTargetAsString(String target) {
        this.target = MigrationVersion.fromVersion(target);
    }

    public void setPlaceholderReplacement(boolean placeholderReplacement) {
        this.placeholderReplacement = placeholderReplacement;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        if (!StringUtils.hasLength(placeholderPrefix)) {
            throw new FlywayException("placeholderPrefix cannot be empty!");
        }
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        if (!StringUtils.hasLength(placeholderSuffix)) {
            throw new FlywayException("placeholderSuffix cannot be empty!");
        }
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    @Override
    public String getUndoSqlMigrationPrefix() {
        throw new FlywayProUpgradeRequiredException("undoSqlMigrationPrefix");
    }

    public void setUndoSqlMigrationPrefix(String undoSqlMigrationPrefix) {
        throw new FlywayProUpgradeRequiredException("undoSqlMigrationPrefix");
    }

    @Override
    public boolean isStream() {
        throw new FlywayProUpgradeRequiredException("stream");
    }

    public void setStream(boolean stream) {
        throw new FlywayProUpgradeRequiredException("stream");
    }

    @Override
    public boolean isBatch() {
        throw new FlywayProUpgradeRequiredException("batch");
    }

    public void setBatch(boolean batch) {
        throw new FlywayProUpgradeRequiredException("batch");
    }

    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        this.repeatableSqlMigrationPrefix = repeatableSqlMigrationPrefix;
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        if (!StringUtils.hasLength(sqlMigrationSeparator)) {
            throw new FlywayException("sqlMigrationSeparator cannot be empty!");
        }
        this.sqlMigrationSeparator = sqlMigrationSeparator;
    }

    public void setSqlMigrationSuffixes(String ... sqlMigrationSuffixes) {
        this.sqlMigrationSuffixes = sqlMigrationSuffixes;
    }

    public void setDataSource(DataSource dataSource) {
        this.driver = null;
        this.url = null;
        this.user = null;
        this.password = null;
        this.dataSource = dataSource;
    }

    public void setDataSource(String url, String user, String password, String ... initSqls) {
        this.dataSource = new DriverDataSource(this.classLoader, null, url, user, password, null, initSqls);
    }

    public void setBaselineVersion(MigrationVersion baselineVersion) {
        this.baselineVersion = baselineVersion;
    }

    public void setBaselineVersionAsString(String baselineVersion) {
        this.baselineVersion = MigrationVersion.fromVersion(baselineVersion);
    }

    public void setBaselineDescription(String baselineDescription) {
        this.baselineDescription = baselineDescription;
    }

    public void setBaselineOnMigrate(boolean baselineOnMigrate) {
        this.baselineOnMigrate = baselineOnMigrate;
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    @Override
    public Callback[] getCallbacks() {
        return this.callbacks.toArray(new Callback[0]);
    }

    @Override
    public boolean isSkipDefaultCallbacks() {
        return this.skipDefaultCallbacks;
    }

    public void setCallbacks(Callback ... callbacks) {
        this.callbacks.clear();
        this.callbacks.addAll(Arrays.asList(callbacks));
    }

    public void setCallbacksAsClassNames(String ... callbacks) {
        this.callbacks.clear();
        for (String callback : callbacks) {
            Object o = ClassUtils.instantiate(callback, this.classLoader);
            if (o instanceof Callback) {
                this.callbacks.add((Callback)o);
                continue;
            }
            if (o instanceof FlywayCallback) {
                this.callbacks.add(new LegacyCallback((FlywayCallback)o));
                continue;
            }
            throw new FlywayException("Invalid callback: " + callback + " (" + o.getClass().getName() + ")");
        }
    }

    public void setSkipDefaultCallbacks(boolean skipDefaultCallbacks) {
        this.skipDefaultCallbacks = skipDefaultCallbacks;
    }

    public void setResolvers(MigrationResolver ... resolvers) {
        this.resolvers = resolvers;
    }

    public void setResolversAsClassNames(String ... resolvers) {
        List<MigrationResolver> resolverList = ClassUtils.instantiateAll(resolvers, this.classLoader);
        this.setResolvers(resolverList.toArray(new MigrationResolver[resolvers.length]));
    }

    public void setSkipDefaultResolvers(boolean skipDefaultResolvers) {
        this.skipDefaultResolvers = skipDefaultResolvers;
    }

    @Override
    public boolean isOracleSqlplus() {
        throw new FlywayProUpgradeRequiredException("oracle.sqlplus");
    }

    public void setOracleSqlplus(boolean oracleSqlplus) {
        throw new FlywayProUpgradeRequiredException("oracle.sqlplus");
    }

    public void configure(Configuration configuration) {
        this.setBaselineDescription(configuration.getBaselineDescription());
        this.setBaselineOnMigrate(configuration.isBaselineOnMigrate());
        this.setBaselineVersion(configuration.getBaselineVersion());
        this.setCallbacks(configuration.getCallbacks());
        this.setCleanDisabled(configuration.isCleanDisabled());
        this.setCleanOnValidationError(configuration.isCleanOnValidationError());
        this.setDataSource(configuration.getDataSource());
        this.setEncoding(configuration.getEncoding());
        this.setGroup(configuration.isGroup());
        this.setIgnoreFutureMigrations(configuration.isIgnoreFutureMigrations());
        this.setIgnoreMissingMigrations(configuration.isIgnoreMissingMigrations());
        this.setIgnoreIgnoredMigrations(configuration.isIgnoreIgnoredMigrations());
        this.setInstalledBy(configuration.getInstalledBy());
        this.setLocations(configuration.getLocations());
        this.setMixed(configuration.isMixed());
        this.setOutOfOrder(configuration.isOutOfOrder());
        this.setPlaceholderPrefix(configuration.getPlaceholderPrefix());
        this.setPlaceholderReplacement(configuration.isPlaceholderReplacement());
        this.setPlaceholders(configuration.getPlaceholders());
        this.setPlaceholderSuffix(configuration.getPlaceholderSuffix());
        this.setRepeatableSqlMigrationPrefix(configuration.getRepeatableSqlMigrationPrefix());
        this.setResolvers(configuration.getResolvers());
        this.setSchemas(configuration.getSchemas());
        this.setSkipDefaultCallbacks(configuration.isSkipDefaultCallbacks());
        this.setSkipDefaultResolvers(configuration.isSkipDefaultResolvers());
        this.setSqlMigrationPrefix(configuration.getSqlMigrationPrefix());
        this.setSqlMigrationSeparator(configuration.getSqlMigrationSeparator());
        this.setSqlMigrationSuffixes(configuration.getSqlMigrationSuffixes());
        this.setTable(configuration.getTable());
        this.setTarget(configuration.getTarget());
        this.setValidateOnMigrate(configuration.isValidateOnMigrate());
    }

    public void configure(Properties properties) {
        this.configure(ConfigUtils.propertiesToMap(properties));
    }

    public void configure(Map<String, String> props) {
        Boolean oracleSqlplusProp;
        Boolean batchProp;
        Boolean streamProp;
        String errorOverridesProp;
        String errorHandlersProp;
        String dryRunOutputProp;
        String installedByProp;
        Boolean groupProp;
        Boolean skipDefaultCallbacksProp;
        String callbacksProp;
        Boolean skipDefaultResolversProp;
        String resolversProp;
        Boolean outOfOrderProp;
        String targetProp;
        Boolean ignoreFutureMigrationsProp;
        Boolean ignoreIgnoredMigrationsProp;
        Boolean ignoreMissingMigrationsProp;
        Boolean baselineOnMigrateProp;
        String baselineDescriptionProp;
        String baselineVersionProp;
        Boolean validateOnMigrateProp;
        Boolean cleanDisabledProp;
        Boolean cleanOnValidationErrorProp;
        String tableProp;
        String schemasProp;
        String encodingProp;
        String sqlMigrationSuffixesProp;
        String sqlMigrationSuffixProp;
        String sqlMigrationSeparatorProp;
        String repeatableSqlMigrationPrefixProp;
        String undoSqlMigrationPrefixProp;
        String sqlMigrationPrefixProp;
        String placeholderSuffixProp;
        String placeholderPrefixProp;
        Boolean placeholderReplacementProp;
        String locationsProp;
        String passwordProp;
        String userProp;
        String urlProp;
        String driverProp = (props = new HashMap<String, String>(props)).remove("flyway.driver");
        if (driverProp != null) {
            this.dataSource = null;
            this.driver = driverProp;
        }
        if ((urlProp = props.remove("flyway.url")) != null) {
            this.dataSource = null;
            this.url = urlProp;
        }
        if ((userProp = props.remove("flyway.user")) != null) {
            this.dataSource = null;
            this.user = userProp;
        }
        if ((passwordProp = props.remove("flyway.password")) != null) {
            this.dataSource = null;
            this.password = passwordProp;
        }
        if (StringUtils.hasText(this.url) && (StringUtils.hasText(urlProp) || StringUtils.hasText(driverProp) || StringUtils.hasText(userProp) || StringUtils.hasText(passwordProp))) {
            this.setDataSource(new DriverDataSource(this.classLoader, this.driver, this.url, this.user, this.password));
        }
        if ((locationsProp = props.remove("flyway.locations")) != null) {
            this.setLocationsAsStrings(StringUtils.tokenizeToStringArray(locationsProp, ","));
        }
        if ((placeholderReplacementProp = this.getBooleanProp(props, "flyway.placeholderReplacement")) != null) {
            this.setPlaceholderReplacement(placeholderReplacementProp);
        }
        if ((placeholderPrefixProp = props.remove("flyway.placeholderPrefix")) != null) {
            this.setPlaceholderPrefix(placeholderPrefixProp);
        }
        if ((placeholderSuffixProp = props.remove("flyway.placeholderSuffix")) != null) {
            this.setPlaceholderSuffix(placeholderSuffixProp);
        }
        if ((sqlMigrationPrefixProp = props.remove("flyway.sqlMigrationPrefix")) != null) {
            this.setSqlMigrationPrefix(sqlMigrationPrefixProp);
        }
        if ((undoSqlMigrationPrefixProp = props.remove("flyway.undoSqlMigrationPrefix")) != null) {
            this.setUndoSqlMigrationPrefix(undoSqlMigrationPrefixProp);
        }
        if ((repeatableSqlMigrationPrefixProp = props.remove("flyway.repeatableSqlMigrationPrefix")) != null) {
            this.setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefixProp);
        }
        if ((sqlMigrationSeparatorProp = props.remove("flyway.sqlMigrationSeparator")) != null) {
            this.setSqlMigrationSeparator(sqlMigrationSeparatorProp);
        }
        if ((sqlMigrationSuffixProp = props.remove("flyway.sqlMigrationSuffix")) != null) {
            this.setSqlMigrationSuffixes(sqlMigrationSuffixProp);
        }
        if ((sqlMigrationSuffixesProp = props.remove("flyway.sqlMigrationSuffixes")) != null) {
            this.setSqlMigrationSuffixes(StringUtils.tokenizeToStringArray(sqlMigrationSuffixesProp, ","));
        }
        if ((encodingProp = props.remove("flyway.encoding")) != null) {
            this.setEncodingAsString(encodingProp);
        }
        if ((schemasProp = props.remove("flyway.schemas")) != null) {
            this.setSchemas(StringUtils.tokenizeToStringArray(schemasProp, ","));
        }
        if ((tableProp = props.remove("flyway.table")) != null) {
            this.setTable(tableProp);
        }
        if ((cleanOnValidationErrorProp = this.getBooleanProp(props, "flyway.cleanOnValidationError")) != null) {
            this.setCleanOnValidationError(cleanOnValidationErrorProp);
        }
        if ((cleanDisabledProp = this.getBooleanProp(props, "flyway.cleanDisabled")) != null) {
            this.setCleanDisabled(cleanDisabledProp);
        }
        if ((validateOnMigrateProp = this.getBooleanProp(props, "flyway.validateOnMigrate")) != null) {
            this.setValidateOnMigrate(validateOnMigrateProp);
        }
        if ((baselineVersionProp = props.remove("flyway.baselineVersion")) != null) {
            this.setBaselineVersion(MigrationVersion.fromVersion(baselineVersionProp));
        }
        if ((baselineDescriptionProp = props.remove("flyway.baselineDescription")) != null) {
            this.setBaselineDescription(baselineDescriptionProp);
        }
        if ((baselineOnMigrateProp = this.getBooleanProp(props, "flyway.baselineOnMigrate")) != null) {
            this.setBaselineOnMigrate(baselineOnMigrateProp);
        }
        if ((ignoreMissingMigrationsProp = this.getBooleanProp(props, "flyway.ignoreMissingMigrations")) != null) {
            this.setIgnoreMissingMigrations(ignoreMissingMigrationsProp);
        }
        if ((ignoreIgnoredMigrationsProp = this.getBooleanProp(props, "flyway.ignoreIgnoredMigrations")) != null) {
            this.setIgnoreIgnoredMigrations(ignoreIgnoredMigrationsProp);
        }
        if ((ignoreFutureMigrationsProp = this.getBooleanProp(props, "flyway.ignoreFutureMigrations")) != null) {
            this.setIgnoreFutureMigrations(ignoreFutureMigrationsProp);
        }
        if ((targetProp = props.remove("flyway.target")) != null) {
            this.setTarget(MigrationVersion.fromVersion(targetProp));
        }
        if ((outOfOrderProp = this.getBooleanProp(props, "flyway.outOfOrder")) != null) {
            this.setOutOfOrder(outOfOrderProp);
        }
        if (StringUtils.hasLength(resolversProp = props.remove("flyway.resolvers"))) {
            this.setResolversAsClassNames(StringUtils.tokenizeToStringArray(resolversProp, ","));
        }
        if ((skipDefaultResolversProp = this.getBooleanProp(props, "flyway.skipDefaultResolvers")) != null) {
            this.setSkipDefaultResolvers(skipDefaultResolversProp);
        }
        if (StringUtils.hasLength(callbacksProp = props.remove("flyway.callbacks"))) {
            this.setCallbacksAsClassNames(StringUtils.tokenizeToStringArray(callbacksProp, ","));
        }
        if ((skipDefaultCallbacksProp = this.getBooleanProp(props, "flyway.skipDefaultCallbacks")) != null) {
            this.setSkipDefaultCallbacks(skipDefaultCallbacksProp);
        }
        HashMap<String, String> placeholdersFromProps = new HashMap<String, String>(this.getPlaceholders());
        Iterator<Map.Entry<String, String>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String propertyName = entry.getKey();
            if (!propertyName.startsWith("flyway.placeholders.") || propertyName.length() <= "flyway.placeholders.".length()) continue;
            String placeholderName = propertyName.substring("flyway.placeholders.".length());
            String placeholderValue = entry.getValue();
            placeholdersFromProps.put(placeholderName, placeholderValue);
            iterator.remove();
        }
        this.setPlaceholders(placeholdersFromProps);
        Boolean mixedProp = this.getBooleanProp(props, "flyway.mixed");
        if (mixedProp != null) {
            this.setMixed(mixedProp);
        }
        if ((groupProp = this.getBooleanProp(props, "flyway.group")) != null) {
            this.setGroup(groupProp);
        }
        if ((installedByProp = props.remove("flyway.installedBy")) != null) {
            this.setInstalledBy(installedByProp);
        }
        if ((dryRunOutputProp = props.remove("flyway.dryRunOutput")) != null) {
            this.setDryRunOutputAsFileName(dryRunOutputProp);
        }
        if ((errorHandlersProp = props.remove("flyway.errorHandlers")) != null) {
            this.setErrorHandlersAsClassNames(StringUtils.tokenizeToStringArray(errorHandlersProp, ","));
        }
        if ((errorOverridesProp = props.remove("flyway.errorOverrides")) != null) {
            this.setErrorOverrides(StringUtils.tokenizeToStringArray(errorOverridesProp, ","));
        }
        if ((streamProp = this.getBooleanProp(props, "flyway.stream")) != null) {
            this.setStream(streamProp);
        }
        if ((batchProp = this.getBooleanProp(props, "flyway.batch")) != null) {
            this.setBatch(batchProp);
        }
        if ((oracleSqlplusProp = this.getBooleanProp(props, "flyway.oracle.sqlplus")) != null) {
            this.setOracleSqlplus(oracleSqlplusProp);
        }
        for (String key : props.keySet()) {
            if (!key.startsWith("flyway.")) continue;
            throw new FlywayException("Unknown configuration property: " + key);
        }
    }

    private Boolean getBooleanProp(Map<String, String> props, String key) {
        String value = props.remove(key);
        if (value != null && !"true".equals(value) && !"false".equals(value)) {
            throw new FlywayException("Invalid value for " + key + " (should be either true or false): " + value);
        }
        return value == null ? null : Boolean.valueOf(value);
    }

    public void configureUsingEnvVars() {
        this.configure(ConfigUtils.environmentVariablesToPropertyMap());
    }
}

