/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.resolver.MigrationInfoHelper;
import org.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import org.flywaydb.core.internal.resolver.ResolvedMigrationImpl;
import org.flywaydb.core.internal.resolver.sql.SqlMigrationExecutor;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.LoadableResource;
import org.flywaydb.core.internal.util.scanner.Resource;
import org.flywaydb.core.internal.util.scanner.Scanner;

public class SqlMigrationResolver
implements MigrationResolver {
    private final Database database;
    private final Scanner scanner;
    private final List<Location> locations;
    private final PlaceholderReplacer placeholderReplacer;
    private final Configuration configuration;

    public SqlMigrationResolver(Database database, Scanner scanner, List<Location> locations, PlaceholderReplacer placeholderReplacer, Configuration configuration) {
        this.database = database;
        this.scanner = scanner;
        this.locations = locations;
        this.placeholderReplacer = placeholderReplacer;
        this.configuration = configuration;
    }

    public List<ResolvedMigration> resolveMigrations() {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        String separator = this.configuration.getSqlMigrationSeparator();
        String[] suffixes = this.configuration.getSqlMigrationSuffixes();
        for (Location location : this.locations) {
            this.scanForMigrations(location, migrations, this.configuration.getSqlMigrationPrefix(), separator, suffixes, false);
            this.scanForMigrations(location, migrations, this.configuration.getRepeatableSqlMigrationPrefix(), separator, suffixes, true);
        }
        Collections.sort(migrations, new ResolvedMigrationComparator());
        return migrations;
    }

    private void scanForMigrations(Location location, List<ResolvedMigration> migrations, String prefix, String separator, String[] suffixes, boolean repeatable) {
        for (LoadableResource resource : this.scanner.scanForResources(location, prefix, suffixes)) {
            String filename = resource.getFilename();
            if (SqlMigrationResolver.isSqlCallback(filename, separator, suffixes)) continue;
            Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(filename, prefix, separator, suffixes, repeatable);
            ResolvedMigrationImpl migration = new ResolvedMigrationImpl();
            migration.setVersion(info.getLeft());
            migration.setDescription(info.getRight());
            migration.setScript(this.extractScriptName(resource, location));
            migration.setChecksum(resource.checksum());
            migration.setType(MigrationType.SQL);
            migration.setPhysicalLocation(resource.getLocationOnDisk());
            migration.setExecutor(new SqlMigrationExecutor(this.database, resource, this.placeholderReplacer, this.configuration));
            migrations.add(migration);
        }
    }

    static boolean isSqlCallback(String filename, String separator, String ... suffixes) {
        for (String suffix : suffixes) {
            String baseName = filename.substring(0, filename.length() - suffix.length());
            int index = baseName.indexOf(separator);
            if (index >= 0) {
                baseName = baseName.substring(0, index);
            }
            if (Event.fromId(baseName) == null) continue;
            return true;
        }
        return false;
    }

    String extractScriptName(Resource resource, Location location) {
        if (location.getPath().isEmpty()) {
            return resource.getLocation();
        }
        return resource.getLocation().substring(location.getPath().length() + 1);
    }
}

