/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.redshift;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.database.Delimiter;
import org.flywaydb.core.internal.database.SqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;

public class RedshiftSqlStatementBuilder
extends SqlStatementBuilder {
    static final String DOLLAR_QUOTE_REGEX = "(\\$[A-Za-z0-9_]*\\$).*";
    private String statementStart = "";

    RedshiftSqlStatementBuilder(Delimiter defaultDelimiter) {
        super(defaultDelimiter);
    }

    @Override
    protected void applyStateChanges(String line) {
        super.applyStateChanges(line);
        if (!this.executeInTransaction) {
            return;
        }
        if (StringUtils.countOccurrencesOf(this.statementStart, " ") < 8) {
            this.statementStart = this.statementStart + line;
            this.statementStart = this.statementStart + " ";
            this.statementStart = StringUtils.collapseWhitespace(this.statementStart);
        }
        if (this.statementStart.matches("^(CREATE|DROP) LIBRARY .*") || this.statementStart.matches("^CREATE EXTERNAL TABLE .*") || this.statementStart.matches("^ALTER TABLE .* APPEND FROM .*") || this.statementStart.matches("^VACUUM .*")) {
            this.executeInTransaction = false;
        }
    }

    @Override
    protected Collection<String> tokenizeLine(String line) {
        return StringUtils.tokenizeToStringCollection(line, " @<>;:=|(),+{}[]");
    }

    @Override
    protected String extractAlternateOpenQuote(String token) {
        Matcher matcher = Pattern.compile(DOLLAR_QUOTE_REGEX).matcher(token);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    protected String cleanToken(String token) {
        if (token.startsWith("E'")) {
            return token.substring(token.indexOf("'"));
        }
        return token;
    }
}

