/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.logging;

import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.logging.android.AndroidLogCreator;
import org.flywaydb.core.internal.util.logging.apachecommons.ApacheCommonsLogCreator;
import org.flywaydb.core.internal.util.logging.javautil.JavaUtilLogCreator;
import org.flywaydb.core.internal.util.logging.slf4j.Slf4jLogCreator;

public class LogFactory {
    private static LogCreator logCreator;
    private static LogCreator fallbackLogCreator;

    private LogFactory() {
    }

    public static void setLogCreator(LogCreator logCreator) {
        LogFactory.logCreator = logCreator;
    }

    public static void setFallbackLogCreator(LogCreator fallbackLogCreator) {
        LogFactory.fallbackLogCreator = fallbackLogCreator;
    }

    public static Log getLog(Class<?> clazz) {
        if (logCreator == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            FeatureDetector featureDetector = new FeatureDetector(classLoader);
            logCreator = featureDetector.isAndroidAvailable() ? (LogCreator)ClassUtils.instantiate(AndroidLogCreator.class.getName(), classLoader) : (featureDetector.isSlf4jAvailable() ? (LogCreator)ClassUtils.instantiate(Slf4jLogCreator.class.getName(), classLoader) : (featureDetector.isApacheCommonsLoggingAvailable() ? (LogCreator)ClassUtils.instantiate(ApacheCommonsLogCreator.class.getName(), classLoader) : (fallbackLogCreator == null ? (LogCreator)ClassUtils.instantiate(JavaUtilLogCreator.class.getName(), classLoader) : fallbackLogCreator)));
        }
        return logCreator.createLogger(clazz);
    }
}

