/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database;

import java.io.Closeable;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.database.Table;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.util.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.jdbc.JdbcUtils;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;

public abstract class Connection<D extends Database>
implements Closeable {
    protected final D database;
    protected final JdbcTemplate jdbcTemplate;
    private final java.sql.Connection jdbcConnection;
    protected final String originalSchema;

    protected Connection(FlywayConfiguration configuration, D database, java.sql.Connection connection, int nullType) {
        this.database = database;
        this.jdbcConnection = connection;
        this.jdbcTemplate = new JdbcTemplate(this.jdbcConnection, nullType);
        this.originalSchema = this.jdbcTemplate.getConnection() == null ? null : this.getCurrentSchemaName();
    }

    public String getCurrentSchemaName() {
        try {
            return this.doGetCurrentSchemaName();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to retrieve the current schema for the connection", e);
        }
    }

    protected abstract String doGetCurrentSchemaName() throws SQLException;

    public Schema getOriginalSchema() {
        if (this.originalSchema == null) {
            return null;
        }
        return this.getSchema(this.originalSchema);
    }

    public abstract Schema getSchema(String var1);

    public void changeCurrentSchemaTo(Schema schema) {
        try {
            if (!schema.exists()) {
                return;
            }
            this.doChangeCurrentSchemaTo(schema.getName());
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error setting current schema to " + schema, e);
        }
    }

    public void restoreCurrentSchema() {
        try {
            this.doChangeCurrentSchemaTo(this.originalSchema);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error restoring current schema to its original setting", e);
        }
    }

    public abstract void doChangeCurrentSchemaTo(String var1) throws SQLException;

    public <T> T lock(final Table table, final Callable<T> callable) {
        return new TransactionTemplate(this.jdbcTemplate.getConnection(), ((Database)this.database).supportsDdlTransactions()).execute(new Callable<T>(){

            @Override
            public T call() throws Exception {
                table.lock();
                return callable.call();
            }
        });
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public void close() {
        JdbcUtils.closeConnection(this.jdbcConnection);
    }

    public java.sql.Connection getJdbcConnection() {
        return this.jdbcConnection;
    }
}

