/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.saphana;

import java.sql.Connection;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.database.saphana.SAPHANAConnection;
import org.flywaydb.core.internal.database.saphana.SAPHANASqlScript;
import org.flywaydb.core.internal.exception.FlywayEnterpriseUpgradeRequiredException;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.LoadableResource;

public class SAPHANADatabase
extends Database<SAPHANAConnection> {
    public SAPHANADatabase(FlywayConfiguration configuration, Connection connection) {
        super(configuration, connection, 12);
    }

    @Override
    protected SAPHANAConnection getConnection(Connection connection, int nullType) {
        return new SAPHANAConnection(this.configuration, this, connection, nullType);
    }

    @Override
    protected void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion;
        if (this.majorVersion == 1) {
            throw new FlywayEnterpriseUpgradeRequiredException("SAP", "HANA", version);
        }
        if (this.majorVersion > 2) {
            this.recommendFlywayUpgrade("SAP HANA", version);
        }
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource) {
        return new SAPHANASqlScript(sqlScriptSource);
    }

    @Override
    public SqlScript createSqlScript(LoadableResource sqlScriptResource, PlaceholderReplacer placeholderReplacer, String encoding, boolean mixed) {
        return new SAPHANASqlScript(sqlScriptResource, placeholderReplacer, encoding, mixed);
    }

    @Override
    public String getDbName() {
        return "saphana";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

