/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.postgresql;

import java.sql.SQLException;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLConnection;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLSqlScript;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import org.flywaydb.core.internal.exception.FlywayEnterpriseUpgradeRequiredException;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.scanner.LoadableResource;

public class PostgreSQLDatabase
extends Database {
    public PostgreSQLDatabase(FlywayConfiguration configuration, java.sql.Connection connection) {
        super(configuration, connection, 0);
    }

    protected Connection getConnection(java.sql.Connection connection, int nullType) {
        return new PostgreSQLConnection(this.configuration, this, connection, nullType);
    }

    @Override
    protected final void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion;
        if (this.majorVersion < 9) {
            throw new FlywayDbUpgradeRequiredException("PostgreSQL", version, "9.0");
        }
        if (this.majorVersion == 9 && this.minorVersion < 3) {
            throw new FlywayEnterpriseUpgradeRequiredException("PostgreSQL", "PostgreSQL", version);
        }
        if (this.majorVersion > 10) {
            this.recommendFlywayUpgrade("PostgreSQL", version);
        }
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource) {
        return new PostgreSQLSqlScript(sqlScriptSource);
    }

    @Override
    public SqlScript createSqlScript(LoadableResource sqlScriptResource, PlaceholderReplacer placeholderReplacer, String encoding, boolean mixed) {
        return new PostgreSQLSqlScript(sqlScriptResource, placeholderReplacer, encoding, mixed);
    }

    @Override
    public String getDbName() {
        return "postgresql";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return this.mainConnection.getJdbcTemplate().queryForString("SELECT current_user", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public String doQuote(String identifier) {
        return PostgreSQLDatabase.pgQuote(identifier);
    }

    static String pgQuote(String identifier) {
        return "\"" + StringUtils.replaceAll(identifier, "\"", "\"\"") + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }
}

