/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle;

import java.sql.SQLException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.Delimiter;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.database.SqlStatementBuilder;
import org.flywaydb.core.internal.database.oracle.OracleContextImpl;
import org.flywaydb.core.internal.database.oracle.OracleSqlStatementBuilder;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.LoadableResource;

class OracleSqlScript
extends SqlScript<OracleContextImpl> {
    private static final Log LOG = LogFactory.getLog(OracleSqlScript.class);

    OracleSqlScript(String sqlScriptSource) {
        super(sqlScriptSource);
    }

    OracleSqlScript(LoadableResource sqlScriptResource, PlaceholderReplacer placeholderReplacer, String encoding, boolean mixed) {
        super(sqlScriptResource, placeholderReplacer, encoding, mixed);
    }

    @Override
    protected SqlStatementBuilder createSqlStatementBuilder() {
        return new OracleSqlStatementBuilder(Delimiter.SEMICOLON);
    }

    @Override
    protected void handleException(SQLException e, SqlStatement sqlStatement, OracleContextImpl context) {
        super.handleException(e, sqlStatement, context);
    }

    @Override
    protected OracleContextImpl createContext() {
        return new OracleContextImpl();
    }
}

