/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.mysql;

import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.database.Table;
import org.flywaydb.core.internal.database.mysql.MySQLDatabase;
import org.flywaydb.core.internal.database.mysql.MySQLNamedLockTemplate;
import org.flywaydb.core.internal.database.mysql.MySQLSchema;
import org.flywaydb.core.internal.util.StringUtils;

public class MySQLConnection
extends Connection<MySQLDatabase> {
    private static final Log LOG = LogFactory.getLog(MySQLConnection.class);

    MySQLConnection(FlywayConfiguration configuration, MySQLDatabase database, java.sql.Connection connection, int nullType) {
        super(configuration, database, connection, nullType);
    }

    @Override
    protected String doGetCurrentSchemaName() throws SQLException {
        return this.jdbcTemplate.getConnection().getCatalog();
    }

    @Override
    public void doChangeCurrentSchemaTo(String schema) throws SQLException {
        if (!StringUtils.hasLength(schema)) {
            try {
                String newDb = ((MySQLDatabase)this.database).quote(UUID.randomUUID().toString());
                this.jdbcTemplate.execute("CREATE SCHEMA " + newDb, new Object[0]);
                this.jdbcTemplate.execute("USE " + newDb, new Object[0]);
                this.jdbcTemplate.execute("DROP SCHEMA " + newDb, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Unable to restore connection to having no default schema: " + e.getMessage());
            }
        } else {
            this.jdbcTemplate.getConnection().setCatalog(schema);
        }
    }

    @Override
    public Schema getSchema(String name) {
        return new MySQLSchema(this.jdbcTemplate, (MySQLDatabase)this.database, name);
    }

    @Override
    public <T> T lock(Table table, Callable<T> callable) {
        return new MySQLNamedLockTemplate(this.jdbcTemplate, table.toString().hashCode()).execute(callable);
    }
}

