/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlserver;

import java.sql.SQLException;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.database.Table;
import org.flywaydb.core.internal.util.jdbc.JdbcTemplate;

public class SQLServerTable
extends Table {
    SQLServerTable(JdbcTemplate jdbcTemplate, Database database, Schema schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + this.database.quote(this.schema.getName(), this.name), new Object[0]);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForBoolean("SELECT CAST(CASE WHEN EXISTS(  SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME=?) THEN 1 ELSE 0 END AS BIT)", this.schema.getName(), this.name);
    }

    @Override
    protected void doLock() throws SQLException {
        this.jdbcTemplate.execute("select * from " + this + " WITH (TABLOCKX)", new Object[0]);
    }
}

