/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.errorhandler.ErrorHandler;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.callback.SqlScriptFlywayCallback;
import org.flywaydb.core.internal.command.DbBaseline;
import org.flywaydb.core.internal.command.DbClean;
import org.flywaydb.core.internal.command.DbInfo;
import org.flywaydb.core.internal.command.DbMigrate;
import org.flywaydb.core.internal.command.DbRepair;
import org.flywaydb.core.internal.command.DbSchemas;
import org.flywaydb.core.internal.command.DbValidate;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.DatabaseFactory;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.exception.FlywayProUpgradeRequiredException;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.schemahistory.SchemaHistoryFactory;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.VersionPrinter;
import org.flywaydb.core.internal.util.jdbc.DriverDataSource;
import org.flywaydb.core.internal.util.scanner.Scanner;

public class Flyway
implements FlywayConfiguration {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private Locations locations = new Locations("db/migration");
    private String encoding = "UTF-8";
    private String[] schemaNames = new String[0];
    private String table = "flyway_schema_history";
    private MigrationVersion target;
    private boolean placeholderReplacement = true;
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String sqlMigrationPrefix = "V";
    private String repeatableSqlMigrationPrefix = "R";
    private String sqlMigrationSeparator = "__";
    private String[] sqlMigrationSuffixes = new String[]{".sql"};
    private boolean ignoreMissingMigrations;
    private boolean ignoreFutureMigrations = true;
    private boolean validateOnMigrate = true;
    private boolean cleanOnValidationError;
    private boolean cleanDisabled;
    private MigrationVersion baselineVersion = MigrationVersion.fromVersion("1");
    private String baselineDescription = "<< Flyway Baseline >>";
    private boolean baselineOnMigrate;
    private boolean outOfOrder;
    private final List<FlywayCallback> callbacks = new ArrayList<FlywayCallback>();
    private boolean skipDefaultCallbacks;
    private MigrationResolver[] resolvers = new MigrationResolver[0];
    private boolean skipDefaultResolvers;
    private DataSource dataSource;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private boolean dbConnectionInfoPrinted;
    private boolean mixed;
    private boolean group;
    private String installedBy;

    public Flyway() {
    }

    public Flyway(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
    }

    public Flyway(FlywayConfiguration configuration) {
        this(configuration.getClassLoader());
        this.setBaselineDescription(configuration.getBaselineDescription());
        this.setBaselineOnMigrate(configuration.isBaselineOnMigrate());
        this.setBaselineVersion(configuration.getBaselineVersion());
        this.setCallbacks(configuration.getCallbacks());
        this.setCleanDisabled(configuration.isCleanDisabled());
        this.setCleanOnValidationError(configuration.isCleanOnValidationError());
        this.setDataSource(configuration.getDataSource());
        this.setEncoding(configuration.getEncoding());
        this.setGroup(configuration.isGroup());
        this.setIgnoreFutureMigrations(configuration.isIgnoreFutureMigrations());
        this.setIgnoreMissingMigrations(configuration.isIgnoreMissingMigrations());
        this.setInstalledBy(configuration.getInstalledBy());
        this.setLocations(configuration.getLocations());
        this.setMixed(configuration.isMixed());
        this.setOutOfOrder(configuration.isOutOfOrder());
        this.setPlaceholderPrefix(configuration.getPlaceholderPrefix());
        this.setPlaceholderReplacement(configuration.isPlaceholderReplacement());
        this.setPlaceholders(configuration.getPlaceholders());
        this.setPlaceholderSuffix(configuration.getPlaceholderSuffix());
        this.setRepeatableSqlMigrationPrefix(configuration.getRepeatableSqlMigrationPrefix());
        this.setResolvers(configuration.getResolvers());
        this.setSchemas(configuration.getSchemas());
        this.setSkipDefaultCallbacks(configuration.isSkipDefaultCallbacks());
        this.setSkipDefaultResolvers(configuration.isSkipDefaultResolvers());
        this.setSqlMigrationPrefix(configuration.getSqlMigrationPrefix());
        this.setSqlMigrationSeparator(configuration.getSqlMigrationSeparator());
        this.setSqlMigrationSuffixes(configuration.getSqlMigrationSuffixes());
        this.setTable(configuration.getTable());
        this.setTarget(configuration.getTarget());
        this.setValidateOnMigrate(configuration.isValidateOnMigrate());
    }

    @Override
    public String[] getLocations() {
        String[] result = new String[this.locations.getLocations().size()];
        for (int i = 0; i < this.locations.getLocations().size(); ++i) {
            result[i] = this.locations.getLocations().get(i).toString();
        }
        return result;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String[] getSchemas() {
        return this.schemaNames;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public MigrationVersion getTarget() {
        return this.target;
    }

    @Override
    public boolean isPlaceholderReplacement() {
        return this.placeholderReplacement;
    }

    @Override
    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    @Override
    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    @Override
    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    @Override
    public String getRepeatableSqlMigrationPrefix() {
        return this.repeatableSqlMigrationPrefix;
    }

    @Override
    public String getSqlMigrationSeparator() {
        return this.sqlMigrationSeparator;
    }

    @Override
    public String getSqlMigrationSuffix() {
        LOG.warn("sqlMigrationSuffix has been deprecated and will be removed in Flyway 6.0.0. Use sqlMigrationSuffixes instead.");
        return this.sqlMigrationSuffixes[0];
    }

    @Override
    public String[] getSqlMigrationSuffixes() {
        return this.sqlMigrationSuffixes;
    }

    @Override
    public boolean isIgnoreMissingMigrations() {
        return this.ignoreMissingMigrations;
    }

    @Override
    public boolean isIgnoreFutureMigrations() {
        return this.ignoreFutureMigrations;
    }

    @Override
    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    @Override
    public boolean isCleanOnValidationError() {
        return this.cleanOnValidationError;
    }

    @Override
    public boolean isCleanDisabled() {
        return this.cleanDisabled;
    }

    @Override
    public MigrationVersion getBaselineVersion() {
        return this.baselineVersion;
    }

    @Override
    public String getBaselineDescription() {
        return this.baselineDescription;
    }

    @Override
    public boolean isBaselineOnMigrate() {
        return this.baselineOnMigrate;
    }

    @Override
    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    @Override
    public MigrationResolver[] getResolvers() {
        return this.resolvers;
    }

    @Override
    public boolean isSkipDefaultResolvers() {
        return this.skipDefaultResolvers;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public boolean isMixed() {
        return this.mixed;
    }

    @Override
    public String getInstalledBy() {
        return this.installedBy;
    }

    @Override
    public boolean isGroup() {
        return this.group;
    }

    @Override
    public ErrorHandler[] getErrorHandlers() {
        throw new FlywayProUpgradeRequiredException("errorHandlers");
    }

    @Override
    public OutputStream getDryRunOutput() {
        throw new FlywayProUpgradeRequiredException("dryRunOutput");
    }

    public void setDryRunOutput(OutputStream dryRunOutput) {
        throw new FlywayProUpgradeRequiredException("dryRunOutput");
    }

    public void setDryRunOutputAsFile(File dryRunOutput) {
        throw new FlywayProUpgradeRequiredException("dryRunOutput");
    }

    public void setDryRunOutputAsFileName(String dryRunOutputFileName) {
        throw new FlywayProUpgradeRequiredException("dryRunOutput");
    }

    public void setErrorHandlers(ErrorHandler ... errorHandlers) {
        throw new FlywayProUpgradeRequiredException("errorHandlers");
    }

    public void setErrorHandlersAsClassNames(String ... errorHandlerClassNames) {
        throw new FlywayProUpgradeRequiredException("errorHandlers");
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public void setInstalledBy(String installedBy) {
        if ("".equals(installedBy)) {
            installedBy = null;
        }
        this.installedBy = installedBy;
    }

    public void setMixed(boolean mixed) {
        this.mixed = mixed;
    }

    public void setIgnoreMissingMigrations(boolean ignoreMissingMigrations) {
        this.ignoreMissingMigrations = ignoreMissingMigrations;
    }

    public void setIgnoreFutureMigrations(boolean ignoreFutureMigrations) {
        this.ignoreFutureMigrations = ignoreFutureMigrations;
    }

    public void setValidateOnMigrate(boolean validateOnMigrate) {
        this.validateOnMigrate = validateOnMigrate;
    }

    public void setCleanOnValidationError(boolean cleanOnValidationError) {
        this.cleanOnValidationError = cleanOnValidationError;
    }

    public void setCleanDisabled(boolean cleanDisabled) {
        this.cleanDisabled = cleanDisabled;
    }

    public void setLocations(String ... locations) {
        this.locations = new Locations(locations);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSchemas(String ... schemas) {
        this.schemaNames = schemas;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setTarget(MigrationVersion target) {
        this.target = target;
    }

    public void setTargetAsString(String target) {
        this.target = MigrationVersion.fromVersion(target);
    }

    public void setPlaceholderReplacement(boolean placeholderReplacement) {
        this.placeholderReplacement = placeholderReplacement;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        if (!StringUtils.hasLength(placeholderPrefix)) {
            throw new FlywayException("placeholderPrefix cannot be empty!");
        }
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        if (!StringUtils.hasLength(placeholderSuffix)) {
            throw new FlywayException("placeholderSuffix cannot be empty!");
        }
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    @Override
    public String getUndoSqlMigrationPrefix() {
        throw new FlywayProUpgradeRequiredException("undoSqlMigrationPrefix");
    }

    public void setUndoSqlMigrationPrefix(String undoSqlMigrationPrefix) {
        throw new FlywayProUpgradeRequiredException("undoSqlMigrationPrefix");
    }

    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefix) {
        this.repeatableSqlMigrationPrefix = repeatableSqlMigrationPrefix;
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        if (!StringUtils.hasLength(sqlMigrationSeparator)) {
            throw new FlywayException("sqlMigrationSeparator cannot be empty!");
        }
        this.sqlMigrationSeparator = sqlMigrationSeparator;
    }

    @Deprecated
    public void setSqlMigrationSuffix(String sqlMigrationSuffix) {
        LOG.warn("sqlMigrationSuffix has been deprecated and will be removed in Flyway 6.0.0. Use sqlMigrationSuffixes instead.");
        this.sqlMigrationSuffixes = new String[]{sqlMigrationSuffix};
    }

    public void setSqlMigrationSuffixes(String ... sqlMigrationSuffixes) {
        this.sqlMigrationSuffixes = sqlMigrationSuffixes;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSource(String url, String user, String password, String ... initSqls) {
        this.dataSource = new DriverDataSource(this.classLoader, null, url, user, password, null, initSqls);
    }

    @Deprecated
    public void setClassLoader(ClassLoader classLoader) {
        LOG.warn("Flyway.setClassLoader() is deprecated and will be removed in Flyway 6.0. Use new Flyway(ClassLoader) instead.");
        this.classLoader = classLoader;
    }

    public void setBaselineVersion(MigrationVersion baselineVersion) {
        this.baselineVersion = baselineVersion;
    }

    public void setBaselineVersionAsString(String baselineVersion) {
        this.baselineVersion = MigrationVersion.fromVersion(baselineVersion);
    }

    public void setBaselineDescription(String baselineDescription) {
        this.baselineDescription = baselineDescription;
    }

    public void setBaselineOnMigrate(boolean baselineOnMigrate) {
        this.baselineOnMigrate = baselineOnMigrate;
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    @Override
    public FlywayCallback[] getCallbacks() {
        return this.callbacks.toArray(new FlywayCallback[this.callbacks.size()]);
    }

    @Override
    public boolean isSkipDefaultCallbacks() {
        return this.skipDefaultCallbacks;
    }

    public void setCallbacks(FlywayCallback ... callbacks) {
        this.callbacks.clear();
        this.callbacks.addAll(Arrays.asList(callbacks));
    }

    public void setCallbacksAsClassNames(String ... callbacks) {
        this.callbacks.clear();
        this.callbacks.addAll(ClassUtils.instantiateAll(callbacks, this.classLoader));
    }

    public void setSkipDefaultCallbacks(boolean skipDefaultCallbacks) {
        this.skipDefaultCallbacks = skipDefaultCallbacks;
    }

    public void setResolvers(MigrationResolver ... resolvers) {
        this.resolvers = resolvers;
    }

    public void setResolversAsClassNames(String ... resolvers) {
        List<MigrationResolver> resolverList = ClassUtils.instantiateAll(resolvers, this.classLoader);
        this.setResolvers(resolverList.toArray(new MigrationResolver[resolvers.length]));
    }

    public void setSkipDefaultResolvers(boolean skipDefaultResolvers) {
        this.skipDefaultResolvers = skipDefaultResolvers;
    }

    public int migrate() throws FlywayException {
        return this.execute(new Command<Integer>(){

            @Override
            public Integer execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, List<FlywayCallback> effectiveCallbacks) {
                if (Flyway.this.validateOnMigrate) {
                    Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, effectiveCallbacks, true);
                }
                new DbSchemas(database, schemas, schemaHistory).create();
                if (!schemaHistory.exists()) {
                    ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                    for (Schema schema : schemas) {
                        if (schema.empty()) continue;
                        nonEmptySchemas.add(schema);
                    }
                    if (!nonEmptySchemas.isEmpty()) {
                        if (Flyway.this.baselineOnMigrate) {
                            new DbBaseline(database, schemaHistory, schemas[0], Flyway.this.baselineVersion, Flyway.this.baselineDescription, effectiveCallbacks).baseline();
                        } else if (!schemaHistory.exists()) {
                            throw new FlywayException("Found non-empty schema(s) " + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + " without schema history table! Use baseline() or set baselineOnMigrate to true to initialize the schema history table.");
                        }
                    }
                }
                return new DbMigrate(database, schemaHistory, schemas[0], migrationResolver, Flyway.this, effectiveCallbacks).migrate();
            }
        });
    }

    public int undo() throws FlywayException {
        throw new FlywayProUpgradeRequiredException("undo");
    }

    public void validate() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, List<FlywayCallback> effectiveCallbacks) {
                Flyway.this.doValidate(database, migrationResolver, schemaHistory, schemas, effectiveCallbacks, false);
                return null;
            }
        });
    }

    private void doValidate(Database database, MigrationResolver migrationResolver, SchemaHistory schemaHistory, Schema[] schemas, List<FlywayCallback> effectiveCallbacks, boolean pending) {
        String validationError = new DbValidate(database, schemaHistory, schemas[0], migrationResolver, this.target, this.outOfOrder, pending, this.ignoreMissingMigrations, this.ignoreFutureMigrations, effectiveCallbacks).validate();
        if (validationError != null) {
            if (this.cleanOnValidationError) {
                new DbClean(database, schemaHistory, schemas, effectiveCallbacks, this.cleanDisabled).clean();
            } else {
                throw new FlywayException("Validate failed: " + validationError);
            }
        }
    }

    public void clean() {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, List<FlywayCallback> effectiveCallbacks) {
                new DbClean(database, schemaHistory, schemas, effectiveCallbacks, Flyway.this.cleanDisabled).clean();
                return null;
            }
        });
    }

    public MigrationInfoService info() {
        return this.execute(new Command<MigrationInfoService>(){

            @Override
            public MigrationInfoService execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, List<FlywayCallback> effectiveCallbacks) {
                return new DbInfo(migrationResolver, schemaHistory, database, Flyway.this, schemas, effectiveCallbacks).info();
            }
        });
    }

    public void baseline() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, List<FlywayCallback> effectiveCallbacks) {
                new DbSchemas(database, schemas, schemaHistory).create();
                new DbBaseline(database, schemaHistory, schemas[0], Flyway.this.baselineVersion, Flyway.this.baselineDescription, effectiveCallbacks).baseline();
                return null;
            }
        });
    }

    public void repair() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Database database, Schema[] schemas, List<FlywayCallback> effectiveCallbacks) {
                new DbRepair(database, schemas[0], migrationResolver, schemaHistory, effectiveCallbacks).repair();
                return null;
            }
        });
    }

    private MigrationResolver createMigrationResolver(Database database, Scanner scanner) {
        for (MigrationResolver resolver : this.resolvers) {
            ConfigUtils.injectFlywayConfiguration(resolver, this);
        }
        return new CompositeMigrationResolver(database, scanner, this, this.locations, this.createPlaceholderReplacer(), this.resolvers);
    }

    private PlaceholderReplacer createPlaceholderReplacer() {
        if (this.placeholderReplacement) {
            return new PlaceholderReplacer(this.placeholders, this.placeholderPrefix, this.placeholderSuffix);
        }
        return PlaceholderReplacer.NO_PLACEHOLDERS;
    }

    public void configure(Properties properties) {
        this.configure(ConfigUtils.propertiesToMap(properties));
    }

    public void configure(Map<String, String> props) {
        String errorHandlersProp;
        String dryRunOutputProp;
        String installedByProp;
        Boolean groupProp;
        Boolean skipDefaultCallbacksProp;
        String callbacksProp;
        Boolean skipDefaultResolversProp;
        String resolversProp;
        Boolean outOfOrderProp;
        String targetProp;
        Boolean ignoreFutureMigrationsProp;
        Boolean ignoreMissingMigrationsProp;
        Boolean baselineOnMigrateProp;
        String baselineDescriptionProp;
        String baselineVersionProp;
        Boolean validateOnMigrateProp;
        Boolean cleanDisabledProp;
        Boolean cleanOnValidationErrorProp;
        String tableProp;
        String schemasProp;
        String encodingProp;
        String sqlMigrationSuffixesProp;
        String sqlMigrationSuffixProp;
        String sqlMigrationSeparatorProp;
        String repeatableSqlMigrationPrefixProp;
        String undoSqlMigrationPrefixProp;
        String sqlMigrationPrefixProp;
        String placeholderSuffixProp;
        String placeholderPrefixProp;
        Boolean placeholderReplacementProp;
        props = new HashMap<String, String>(props);
        String driverProp = props.remove("flyway.driver");
        String urlProp = props.remove("flyway.url");
        String userProp = props.remove("flyway.user");
        String passwordProp = props.remove("flyway.password");
        if (StringUtils.hasText(urlProp)) {
            this.setDataSource(new DriverDataSource(this.classLoader, driverProp, urlProp, userProp, passwordProp, null, new String[0]));
        } else if (!StringUtils.hasText(urlProp) && (StringUtils.hasText(driverProp) || StringUtils.hasText(userProp) || StringUtils.hasText(passwordProp))) {
            LOG.warn("Discarding INCOMPLETE dataSource configuration! flyway.url must be set.");
        }
        String locationsProp = props.remove("flyway.locations");
        if (locationsProp != null) {
            this.setLocations(StringUtils.tokenizeToStringArray(locationsProp, ","));
        }
        if ((placeholderReplacementProp = this.getBooleanProp(props, "flyway.placeholderReplacement")) != null) {
            this.setPlaceholderReplacement(placeholderReplacementProp);
        }
        if ((placeholderPrefixProp = props.remove("flyway.placeholderPrefix")) != null) {
            this.setPlaceholderPrefix(placeholderPrefixProp);
        }
        if ((placeholderSuffixProp = props.remove("flyway.placeholderSuffix")) != null) {
            this.setPlaceholderSuffix(placeholderSuffixProp);
        }
        if ((sqlMigrationPrefixProp = props.remove("flyway.sqlMigrationPrefix")) != null) {
            this.setSqlMigrationPrefix(sqlMigrationPrefixProp);
        }
        if ((undoSqlMigrationPrefixProp = props.remove("flyway.undoSqlMigrationPrefix")) != null) {
            this.setUndoSqlMigrationPrefix(undoSqlMigrationPrefixProp);
        }
        if ((repeatableSqlMigrationPrefixProp = props.remove("flyway.repeatableSqlMigrationPrefix")) != null) {
            this.setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefixProp);
        }
        if ((sqlMigrationSeparatorProp = props.remove("flyway.sqlMigrationSeparator")) != null) {
            this.setSqlMigrationSeparator(sqlMigrationSeparatorProp);
        }
        if ((sqlMigrationSuffixProp = props.remove("flyway.sqlMigrationSuffix")) != null) {
            this.setSqlMigrationSuffix(sqlMigrationSuffixProp);
        }
        if ((sqlMigrationSuffixesProp = props.remove("flyway.sqlMigrationSuffixes")) != null) {
            this.setSqlMigrationSuffixes(StringUtils.tokenizeToStringArray(sqlMigrationSuffixesProp, ","));
        }
        if ((encodingProp = props.remove("flyway.encoding")) != null) {
            this.setEncoding(encodingProp);
        }
        if ((schemasProp = props.remove("flyway.schemas")) != null) {
            this.setSchemas(StringUtils.tokenizeToStringArray(schemasProp, ","));
        }
        if ((tableProp = props.remove("flyway.table")) != null) {
            this.setTable(tableProp);
        }
        if ((cleanOnValidationErrorProp = this.getBooleanProp(props, "flyway.cleanOnValidationError")) != null) {
            this.setCleanOnValidationError(cleanOnValidationErrorProp);
        }
        if ((cleanDisabledProp = this.getBooleanProp(props, "flyway.cleanDisabled")) != null) {
            this.setCleanDisabled(cleanDisabledProp);
        }
        if ((validateOnMigrateProp = this.getBooleanProp(props, "flyway.validateOnMigrate")) != null) {
            this.setValidateOnMigrate(validateOnMigrateProp);
        }
        if ((baselineVersionProp = props.remove("flyway.baselineVersion")) != null) {
            this.setBaselineVersion(MigrationVersion.fromVersion(baselineVersionProp));
        }
        if ((baselineDescriptionProp = props.remove("flyway.baselineDescription")) != null) {
            this.setBaselineDescription(baselineDescriptionProp);
        }
        if ((baselineOnMigrateProp = this.getBooleanProp(props, "flyway.baselineOnMigrate")) != null) {
            this.setBaselineOnMigrate(baselineOnMigrateProp);
        }
        if ((ignoreMissingMigrationsProp = this.getBooleanProp(props, "flyway.ignoreMissingMigrations")) != null) {
            this.setIgnoreMissingMigrations(ignoreMissingMigrationsProp);
        }
        if ((ignoreFutureMigrationsProp = this.getBooleanProp(props, "flyway.ignoreFutureMigrations")) != null) {
            this.setIgnoreFutureMigrations(ignoreFutureMigrationsProp);
        }
        if ((targetProp = props.remove("flyway.target")) != null) {
            this.setTarget(MigrationVersion.fromVersion(targetProp));
        }
        if ((outOfOrderProp = this.getBooleanProp(props, "flyway.outOfOrder")) != null) {
            this.setOutOfOrder(outOfOrderProp);
        }
        if (StringUtils.hasLength(resolversProp = props.remove("flyway.resolvers"))) {
            this.setResolversAsClassNames(StringUtils.tokenizeToStringArray(resolversProp, ","));
        }
        if ((skipDefaultResolversProp = this.getBooleanProp(props, "flyway.skipDefaultResolvers")) != null) {
            this.setSkipDefaultResolvers(skipDefaultResolversProp);
        }
        if (StringUtils.hasLength(callbacksProp = props.remove("flyway.callbacks"))) {
            this.setCallbacksAsClassNames(StringUtils.tokenizeToStringArray(callbacksProp, ","));
        }
        if ((skipDefaultCallbacksProp = this.getBooleanProp(props, "flyway.skipDefaultCallbacks")) != null) {
            this.setSkipDefaultCallbacks(skipDefaultCallbacksProp);
        }
        HashMap<String, String> placeholdersFromProps = new HashMap<String, String>(this.placeholders);
        Iterator<Map.Entry<String, String>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String propertyName = entry.getKey();
            if (!propertyName.startsWith("flyway.placeholders.") || propertyName.length() <= "flyway.placeholders.".length()) continue;
            String placeholderName = propertyName.substring("flyway.placeholders.".length());
            String placeholderValue = entry.getValue();
            placeholdersFromProps.put(placeholderName, placeholderValue);
            iterator.remove();
        }
        this.setPlaceholders(placeholdersFromProps);
        Boolean mixedProp = this.getBooleanProp(props, "flyway.mixed");
        if (mixedProp != null) {
            this.setMixed(mixedProp);
        }
        if ((groupProp = this.getBooleanProp(props, "flyway.group")) != null) {
            this.setGroup(groupProp);
        }
        if ((installedByProp = props.remove("flyway.installedBy")) != null) {
            this.setInstalledBy(installedByProp);
        }
        if ((dryRunOutputProp = props.remove("flyway.dryRunOutput")) != null) {
            this.setDryRunOutputAsFileName(dryRunOutputProp);
        }
        if ((errorHandlersProp = props.remove("flyway.errorHandlers")) != null) {
            this.setErrorHandlersAsClassNames(StringUtils.tokenizeToStringArray(errorHandlersProp, ","));
        }
        for (String key : props.keySet()) {
            if (!key.startsWith("flyway.")) continue;
            throw new FlywayException("Unknown configuration property: " + key);
        }
    }

    private Boolean getBooleanProp(Map<String, String> props, String key) {
        String value = props.remove(key);
        if (value != null && !"true".equals(value) && !"false".equals(value)) {
            throw new FlywayException("Invalid value for " + key + " (should be either true or false): " + value);
        }
        return value == null ? null : Boolean.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(Command<T> command) {
        T result;
        VersionPrinter.printVersion();
        if (this.dataSource == null) {
            throw new FlywayException("Unable to connect to the database. Configure the url, user and password!");
        }
        try (Database database = null;){
            database = DatabaseFactory.createDatabase(this, !this.dbConnectionInfoPrinted);
            this.dbConnectionInfoPrinted = true;
            LOG.debug("DDL Transactions Supported: " + database.supportsDdlTransactions());
            Schema[] schemas = this.prepareSchemas(database);
            Scanner scanner = new Scanner(this.classLoader);
            MigrationResolver migrationResolver = this.createMigrationResolver(database, scanner);
            List<FlywayCallback> effectiveCallbacks = this.prepareCallbacks(scanner, database);
            SchemaHistory schemaHistory = SchemaHistoryFactory.getSchemaHistory(this, database, schemas[0]);
            result = command.execute(migrationResolver, schemaHistory, database, schemas, effectiveCallbacks);
        }
        return result;
    }

    private Schema[] prepareSchemas(Database database) {
        if (this.schemaNames.length == 0) {
            Schema currentSchema = ((Connection)database.getMainConnection()).getOriginalSchema();
            if (currentSchema == null) {
                throw new FlywayException("Unable to determine schema for the schema history table. Set a default schema for the connection or specify one using the schemas property!");
            }
            this.setSchemas(currentSchema.getName());
        }
        if (this.schemaNames.length == 1) {
            LOG.debug("Schema: " + this.schemaNames[0]);
        } else {
            LOG.debug("Schemas: " + StringUtils.arrayToCommaDelimitedString(this.schemaNames));
        }
        Schema[] schemas = new Schema[this.schemaNames.length];
        for (int i = 0; i < this.schemaNames.length; ++i) {
            schemas[i] = ((Connection)database.getMainConnection()).getSchema(this.schemaNames[i]);
        }
        return schemas;
    }

    private List<FlywayCallback> prepareCallbacks(Scanner scanner, Database database) {
        ArrayList<FlywayCallback> effectiveCallbacks = new ArrayList<FlywayCallback>();
        effectiveCallbacks.addAll(this.callbacks);
        if (!this.skipDefaultCallbacks) {
            effectiveCallbacks.add(new SqlScriptFlywayCallback(database, scanner, this.locations, this.createPlaceholderReplacer(), this));
        }
        for (FlywayCallback callback : effectiveCallbacks) {
            ConfigUtils.injectFlywayConfiguration(callback, this);
        }
        return effectiveCallbacks;
    }

    static interface Command<T> {
        public T execute(MigrationResolver var1, SchemaHistory var2, Database var3, Schema[] var4, List<FlywayCallback> var5);
    }
}

