/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.sql;

import java.sql.Connection;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.resolver.MigrationExecutor;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.LoadableResource;

public class SqlMigrationExecutor
implements MigrationExecutor {
    private final Database database;
    private final PlaceholderReplacer placeholderReplacer;
    private final LoadableResource sqlScriptResource;
    private final FlywayConfiguration configuration;
    private SqlScript sqlScript;

    public SqlMigrationExecutor(Database database, LoadableResource sqlScriptResource, PlaceholderReplacer placeholderReplacer, FlywayConfiguration configuration) {
        this.database = database;
        this.sqlScriptResource = sqlScriptResource;
        this.placeholderReplacer = placeholderReplacer;
        this.configuration = configuration;
    }

    @Override
    public void execute(Connection connection) {
        this.getSqlScript().execute(((org.flywaydb.core.internal.database.Connection)this.database.getMigrationConnection()).getJdbcTemplate());
    }

    private synchronized SqlScript getSqlScript() {
        if (this.sqlScript == null) {
            this.sqlScript = new SqlScript(this.database, this.sqlScriptResource, this.placeholderReplacer, this.configuration.getEncoding(), this.configuration.isMixed());
        }
        return this.sqlScript;
    }

    @Override
    public boolean executeInTransaction() {
        return this.getSqlScript().executeInTransaction();
    }
}

