/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlite;

import java.sql.SQLException;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlStatementBuilder;
import org.flywaydb.core.internal.database.sqlite.SQLiteConnection;
import org.flywaydb.core.internal.database.sqlite.SQLiteSqlStatementBuilder;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;

public class SQLiteDatabase
extends Database {
    public SQLiteDatabase(FlywayConfiguration configuration, java.sql.Connection connection) {
        super(configuration, connection, 12);
    }

    protected Connection getConnection(java.sql.Connection connection, int nullType) {
        return new SQLiteConnection(this.configuration, this, connection, nullType);
    }

    @Override
    protected final void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion;
        if (this.majorVersion < 3) {
            throw new FlywayDbUpgradeRequiredException("SQLite", version, "3.7.2");
        }
    }

    @Override
    public String getDbName() {
        return "sqlite";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new SQLiteSqlStatementBuilder(this.getDefaultDelimiter());
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }
}

