/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.hsqldb;

import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlStatementBuilder;
import org.flywaydb.core.internal.database.hsqldb.HSQLDBConnection;
import org.flywaydb.core.internal.database.hsqldb.HSQLDBSqlStatementBuilder;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;

public class HSQLDBDatabase
extends Database {
    public HSQLDBDatabase(FlywayConfiguration configuration, java.sql.Connection connection) {
        super(configuration, connection, 12);
    }

    protected Connection getConnection(java.sql.Connection connection, int nullType) {
        return new HSQLDBConnection(this.configuration, this, connection, nullType);
    }

    @Override
    protected final void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion;
        if (this.majorVersion < 1 || this.majorVersion == 18 && this.minorVersion < 8) {
            throw new FlywayDbUpgradeRequiredException("HSQLDB", version, "1.8");
        }
    }

    @Override
    public String getDbName() {
        return "hsqldb";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new HSQLDBSqlStatementBuilder(this.getDefaultDelimiter());
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }
}

