/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.db2;

import java.util.Deque;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.database.Delimiter;
import org.flywaydb.core.internal.database.SqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;

public class DB2SqlStatementBuilder
extends SqlStatementBuilder {
    private static final String DELIMITER_KEYWORD = "--#SET TERMINATOR";
    private static final Pattern BEGIN_REGEX = Pattern.compile("((([A-Z]+[A-Z0-9]*)\\s?:\\s?)|(.*\\s))?BEGIN(\\sATOMIC)?(\\s.*)?");
    private static final Pattern KEYWORDS_AFTER_STRING_LITERAL_REGEX = Pattern.compile("(.*')(DO)(?!.)");
    private Deque<String> beginEndLabels = new LinkedList<String>();
    private String statementStart = "";
    private Delimiter currentDelimiter = this.defaultDelimiter;

    public DB2SqlStatementBuilder(Delimiter defaultDelimiter) {
        super(defaultDelimiter);
    }

    @Override
    public Delimiter extractNewDelimiterFromLine(String line) {
        if (line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
            return new Delimiter(line.substring(DELIMITER_KEYWORD.length()).trim(), false);
        }
        return null;
    }

    @Override
    protected boolean isSingleLineComment(String line) {
        return line.startsWith("--") && !line.startsWith(DELIMITER_KEYWORD);
    }

    @Override
    protected String cleanToken(String token) {
        if (token.startsWith("X'")) {
            return token.substring(token.indexOf("'"));
        }
        Matcher afterMatcher = KEYWORDS_AFTER_STRING_LITERAL_REGEX.matcher(token);
        if (afterMatcher.find()) {
            token = afterMatcher.group(1);
        }
        return super.cleanToken(token);
    }

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (delimiter != null && !delimiter.equals(this.currentDelimiter)) {
            this.currentDelimiter = delimiter;
        }
        if (StringUtils.countOccurrencesOf(this.statementStart, " ") < 4) {
            this.statementStart = this.statementStart + line;
            this.statementStart = this.statementStart + " ";
        }
        if (!";".equals(this.currentDelimiter.getDelimiter())) {
            return this.currentDelimiter;
        }
        if (this.statementStart.matches("^CREATE( OR REPLACE)? (FUNCTION|PROCEDURE|TRIGGER)(\\s.*)?")) {
            if (DB2SqlStatementBuilder.isBegin(line) || line.matches("(.*\\s)?CASE(\\sWHEN)?(\\s.*)?")) {
                this.beginEndLabels.addLast(DB2SqlStatementBuilder.extractLabel(line));
            }
            if (DB2SqlStatementBuilder.isEnd(line, this.beginEndLabels.isEmpty() ? null : this.beginEndLabels.getLast(), this.currentDelimiter, this.beginEndLabels.size())) {
                this.beginEndLabels.removeLast();
            }
        }
        if (!this.beginEndLabels.isEmpty()) {
            return null;
        }
        return this.currentDelimiter;
    }

    static boolean isBegin(String line) {
        return BEGIN_REGEX.matcher(line).find();
    }

    static String extractLabel(String line) {
        Matcher matcher = BEGIN_REGEX.matcher(line);
        return line.contains(":") && matcher.matches() ? matcher.group(3) : null;
    }

    static boolean isEnd(String line, String label, Delimiter currentDelimiter, int beginEndDepth) {
        String actualDelimiter = beginEndDepth > 1 ? ";" : currentDelimiter.getDelimiter();
        return line.matches("(.*\\s)?END" + (label == null ? "" : "(\\s" + Pattern.quote(label) + ")?") + "\\s?(" + Pattern.quote(actualDelimiter) + ")?");
    }
}

