/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.callback;

import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.util.Location;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.scanner.LoadableResource;
import org.flywaydb.core.internal.util.scanner.Scanner;

public class SqlScriptFlywayCallback
implements FlywayCallback {
    private static final Log LOG = LogFactory.getLog(SqlScriptFlywayCallback.class);
    private static final String BEFORE_CLEAN = "beforeClean";
    private static final String AFTER_CLEAN = "afterClean";
    private static final String BEFORE_MIGRATE = "beforeMigrate";
    private static final String AFTER_MIGRATE = "afterMigrate";
    private static final String BEFORE_EACH_MIGRATE = "beforeEachMigrate";
    private static final String AFTER_EACH_MIGRATE = "afterEachMigrate";
    private static final String BEFORE_VALIDATE = "beforeValidate";
    private static final String AFTER_VALIDATE = "afterValidate";
    private static final String BEFORE_BASELINE = "beforeBaseline";
    private static final String AFTER_BASELINE = "afterBaseline";
    private static final String BEFORE_REPAIR = "beforeRepair";
    private static final String AFTER_REPAIR = "afterRepair";
    private static final String BEFORE_INFO = "beforeInfo";
    private static final String AFTER_INFO = "afterInfo";
    public static final List<String> ALL_CALLBACKS = Arrays.asList("beforeClean", "afterClean", "beforeMigrate", "beforeEachMigrate", "afterEachMigrate", "afterMigrate", "beforeValidate", "afterValidate", "beforeBaseline", "afterBaseline", "beforeRepair", "afterRepair", "beforeInfo", "afterInfo");
    private final Map<String, SqlScript> scripts = new HashMap<String, SqlScript>();

    public SqlScriptFlywayCallback(Database database, Scanner scanner, Locations locations, PlaceholderReplacer placeholderReplacer, FlywayConfiguration configuration) {
        for (String callback : ALL_CALLBACKS) {
            this.scripts.put(callback, null);
        }
        LOG.debug("Scanning for SQL callbacks ...");
        for (Location location : locations.getLocations()) {
            LoadableResource[] resources;
            try {
                resources = scanner.scanForResources(location, "", configuration.getSqlMigrationSuffixes());
            }
            catch (FlywayException e) {
                continue;
            }
            for (LoadableResource resource : resources) {
                String key = this.stripSuffix(resource.getFilename(), configuration.getSqlMigrationSuffixes());
                if (!this.scripts.keySet().contains(key)) continue;
                SqlScript existing = this.scripts.get(key);
                if (existing != null) {
                    throw new FlywayException("Found more than 1 SQL callback script for " + key + "!\nOffenders:\n-> " + existing.getResource().getLocationOnDisk() + "\n-> " + resource.getLocationOnDisk());
                }
                this.scripts.put(key, new SqlScript(database, resource, placeholderReplacer, configuration.getEncoding(), configuration.isMixed()));
            }
        }
    }

    private String stripSuffix(String fileName, String[] suffixes) {
        for (String suffix : suffixes) {
            if (!fileName.endsWith(suffix)) continue;
            return fileName.substring(0, fileName.length() - suffix.length());
        }
        return fileName;
    }

    @Override
    public void beforeClean(Connection connection) {
        this.execute(BEFORE_CLEAN, connection);
    }

    @Override
    public void afterClean(Connection connection) {
        this.execute(AFTER_CLEAN, connection);
    }

    @Override
    public void beforeMigrate(Connection connection) {
        this.execute(BEFORE_MIGRATE, connection);
    }

    @Override
    public void afterMigrate(Connection connection) {
        this.execute(AFTER_MIGRATE, connection);
    }

    @Override
    public void beforeEachMigrate(Connection connection, MigrationInfo info) {
        this.execute(BEFORE_EACH_MIGRATE, connection);
    }

    @Override
    public void afterEachMigrate(Connection connection, MigrationInfo info) {
        this.execute(AFTER_EACH_MIGRATE, connection);
    }

    @Override
    public void beforeUndo(Connection connection) {
    }

    @Override
    public void afterUndo(Connection connection) {
    }

    @Override
    public void beforeEachUndo(Connection connection, MigrationInfo info) {
    }

    @Override
    public void afterEachUndo(Connection connection, MigrationInfo info) {
    }

    @Override
    public void beforeValidate(Connection connection) {
        this.execute(BEFORE_VALIDATE, connection);
    }

    @Override
    public void afterValidate(Connection connection) {
        this.execute(AFTER_VALIDATE, connection);
    }

    @Override
    public void beforeBaseline(Connection connection) {
        this.execute(BEFORE_BASELINE, connection);
    }

    @Override
    public void afterBaseline(Connection connection) {
        this.execute(AFTER_BASELINE, connection);
    }

    @Override
    public void beforeRepair(Connection connection) {
        this.execute(BEFORE_REPAIR, connection);
    }

    @Override
    public void afterRepair(Connection connection) {
        this.execute(AFTER_REPAIR, connection);
    }

    @Override
    public void beforeInfo(Connection connection) {
        this.execute(BEFORE_INFO, connection);
    }

    @Override
    public void afterInfo(Connection connection) {
        this.execute(AFTER_INFO, connection);
    }

    private void execute(String key, Connection connection) {
        SqlScript sqlScript = this.scripts.get(key);
        if (sqlScript != null) {
            LOG.info("Executing SQL callback: " + key);
            sqlScript.execute(new JdbcTemplate(connection, 0));
        }
    }
}

