/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.info.MigrationInfoContext;
import org.flywaydb.core.internal.info.MigrationInfoImpl;
import org.flywaydb.core.internal.metadatatable.AppliedMigration;
import org.flywaydb.core.internal.metadatatable.MetaDataTable;
import org.flywaydb.core.internal.util.ObjectUtils;
import org.flywaydb.core.internal.util.Pair;

public class MigrationInfoServiceImpl
implements MigrationInfoService {
    private final MigrationResolver migrationResolver;
    private final MetaDataTable metaDataTable;
    private MigrationVersion target;
    private boolean outOfOrder;
    private final boolean pending;
    private final boolean missing;
    private final boolean future;
    private List<MigrationInfoImpl> migrationInfos;

    public MigrationInfoServiceImpl(MigrationResolver migrationResolver, MetaDataTable metaDataTable, MigrationVersion target, boolean outOfOrder, boolean pending, boolean missing, boolean future) {
        this.migrationResolver = migrationResolver;
        this.metaDataTable = metaDataTable;
        this.target = target;
        this.outOfOrder = outOfOrder;
        this.pending = pending;
        this.missing = missing;
        this.future = future;
    }

    public void refresh() {
        Collection<ResolvedMigration> availableMigrations = this.migrationResolver.resolveMigrations();
        List<AppliedMigration> appliedMigrations = this.metaDataTable.allAppliedMigrations();
        MigrationInfoContext context = new MigrationInfoContext();
        context.outOfOrder = this.outOfOrder;
        context.pending = this.pending;
        context.missing = this.missing;
        context.future = this.future;
        context.target = this.target;
        TreeMap<Object, ResolvedMigration> resolvedMigrationsMap = new TreeMap<Object, ResolvedMigration>();
        TreeMap<String, ResolvedMigration> resolvedRepeatableMigrationsMap = new TreeMap<String, ResolvedMigration>();
        for (ResolvedMigration resolvedMigration : availableMigrations) {
            MigrationVersion version = resolvedMigration.getVersion();
            if (version != null) {
                if (version.compareTo(context.lastResolved) > 0) {
                    context.lastResolved = version;
                }
                resolvedMigrationsMap.put(version, resolvedMigration);
                continue;
            }
            resolvedRepeatableMigrationsMap.put(resolvedMigration.getDescription(), resolvedMigration);
        }
        TreeMap<MigrationVersion, Pair<AppliedMigration, Boolean>> appliedMigrationsMap = new TreeMap<MigrationVersion, Pair<AppliedMigration, Boolean>>();
        ArrayList<AppliedMigration> appliedRepeatableMigrations = new ArrayList<AppliedMigration>();
        for (AppliedMigration appliedMigration : appliedMigrations) {
            Iterator version = appliedMigration.getVersion();
            boolean outOfOrder1 = false;
            if (version != null) {
                if (((MigrationVersion)((Object)version)).compareTo(context.lastApplied) > 0) {
                    context.lastApplied = version;
                } else {
                    outOfOrder1 = true;
                }
            }
            if (appliedMigration.getType() == MigrationType.SCHEMA) {
                context.schema = version;
            }
            if (appliedMigration.getType() == MigrationType.BASELINE) {
                context.baseline = version;
            }
            if (version != null) {
                appliedMigrationsMap.put((MigrationVersion)((Object)version), Pair.of(appliedMigration, outOfOrder1));
                continue;
            }
            appliedRepeatableMigrations.add(appliedMigration);
        }
        if (MigrationVersion.CURRENT == this.target) {
            context.target = context.lastApplied;
        }
        HashSet allVersions = new HashSet();
        allVersions.addAll(resolvedMigrationsMap.keySet());
        allVersions.addAll(appliedMigrationsMap.keySet());
        ArrayList<MigrationInfoImpl> migrationInfos1 = new ArrayList<MigrationInfoImpl>();
        for (MigrationVersion version : allVersions) {
            ResolvedMigration resolvedMigration = (ResolvedMigration)resolvedMigrationsMap.get(version);
            Pair appliedMigrationInfo = (Pair)appliedMigrationsMap.get(version);
            if (appliedMigrationInfo == null) {
                migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, null, context, false));
                continue;
            }
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, (AppliedMigration)appliedMigrationInfo.getLeft(), context, (Boolean)appliedMigrationInfo.getRight()));
        }
        for (AppliedMigration appliedRepeatableMigration : appliedRepeatableMigrations) {
            if (context.latestRepeatableRuns.containsKey(appliedRepeatableMigration.getDescription()) && appliedRepeatableMigration.getInstalledRank() <= context.latestRepeatableRuns.get(appliedRepeatableMigration.getDescription())) continue;
            context.latestRepeatableRuns.put(appliedRepeatableMigration.getDescription(), appliedRepeatableMigration.getInstalledRank());
        }
        HashSet pendingResolvedRepeatableMigrations = new HashSet(resolvedRepeatableMigrationsMap.values());
        for (AppliedMigration appliedRepeatableMigration : appliedRepeatableMigrations) {
            ResolvedMigration resolvedMigration = (ResolvedMigration)resolvedRepeatableMigrationsMap.get(appliedRepeatableMigration.getDescription());
            int latestRank = context.latestRepeatableRuns.get(appliedRepeatableMigration.getDescription());
            if (resolvedMigration != null && appliedRepeatableMigration.getInstalledRank() == latestRank && ObjectUtils.nullSafeEquals(appliedRepeatableMigration.getChecksum(), resolvedMigration.getChecksum())) {
                pendingResolvedRepeatableMigrations.remove(resolvedMigration);
            }
            migrationInfos1.add(new MigrationInfoImpl(resolvedMigration, appliedRepeatableMigration, context, false));
        }
        for (ResolvedMigration pendingResolvedRepeatableMigration : pendingResolvedRepeatableMigrations) {
            migrationInfos1.add(new MigrationInfoImpl(pendingResolvedRepeatableMigration, null, context, false));
        }
        Collections.sort(migrationInfos1);
        this.migrationInfos = migrationInfos1;
    }

    @Override
    public MigrationInfo[] all() {
        return this.migrationInfos.toArray(new MigrationInfoImpl[this.migrationInfos.size()]);
    }

    @Override
    public MigrationInfo current() {
        MigrationInfoImpl current = null;
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isApplied() || migrationInfo.getVersion() == null || current != null && migrationInfo.getVersion().compareTo(current.getVersion()) <= 0) continue;
            current = migrationInfo;
        }
        if (current != null) {
            return current;
        }
        for (int i = this.migrationInfos.size() - 1; i >= 0; --i) {
            MigrationInfoImpl migrationInfo;
            migrationInfo = this.migrationInfos.get(i);
            if (migrationInfo.getAppliedMigration() == null) continue;
            return migrationInfo;
        }
        return null;
    }

    public MigrationInfoImpl[] pending() {
        ArrayList<MigrationInfoImpl> pendingMigrations = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (MigrationState.PENDING != migrationInfo.getState()) continue;
            pendingMigrations.add(migrationInfo);
        }
        return pendingMigrations.toArray(new MigrationInfoImpl[pendingMigrations.size()]);
    }

    @Override
    public MigrationInfo[] applied() {
        ArrayList<MigrationInfo> appliedMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isApplied()) continue;
            appliedMigrations.add(migrationInfo);
        }
        return appliedMigrations.toArray(new MigrationInfo[appliedMigrations.size()]);
    }

    public MigrationInfo[] resolved() {
        ArrayList<MigrationInfo> resolvedMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isResolved()) continue;
            resolvedMigrations.add(migrationInfo);
        }
        return resolvedMigrations.toArray(new MigrationInfo[resolvedMigrations.size()]);
    }

    public MigrationInfo[] failed() {
        ArrayList<MigrationInfo> failedMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isFailed()) continue;
            failedMigrations.add(migrationInfo);
        }
        return failedMigrations.toArray(new MigrationInfo[failedMigrations.size()]);
    }

    public MigrationInfo[] future() {
        ArrayList<MigrationInfo> futureMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (migrationInfo.getState() != MigrationState.FUTURE_SUCCESS && migrationInfo.getState() != MigrationState.FUTURE_FAILED) continue;
            futureMigrations.add(migrationInfo);
        }
        return futureMigrations.toArray(new MigrationInfo[futureMigrations.size()]);
    }

    public MigrationInfo[] outOfOrder() {
        ArrayList<MigrationInfo> outOfOrderMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (migrationInfo.getState() != MigrationState.OUT_OF_ORDER) continue;
            outOfOrderMigrations.add(migrationInfo);
        }
        return outOfOrderMigrations.toArray(new MigrationInfo[outOfOrderMigrations.size()]);
    }

    public String validate() {
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            String message = migrationInfo.validate();
            if (message == null) continue;
            return message;
        }
        return null;
    }
}

