/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.FlywaySqlException;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.dbsupport.oracle.OracleSchema;
import org.flywaydb.core.internal.dbsupport.oracle.OracleSqlStatementBuilder;
import org.flywaydb.core.internal.util.jdbc.RowMapper;

public class OracleDbSupport
extends DbSupport {
    public OracleDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 12));
    }

    @Override
    public String getDbName() {
        return "oracle";
    }

    @Override
    public String getCurrentUserFunction() {
        return "USER";
    }

    public String getCurrentUserName() {
        try {
            return this.jdbcTemplate.queryForString("SELECT USER FROM DUAL", new String[0]);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to retrieve the current user for the connection", e);
        }
    }

    @Override
    protected String doGetCurrentSchemaName() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL", new String[0]);
    }

    @Override
    protected void doChangeCurrentSchemaTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("ALTER SESSION SET CURRENT_SCHEMA=" + this.quote(schema), new Object[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new OracleSqlStatementBuilder();
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public Schema getSchema(String name) {
        return new OracleSchema(this.jdbcTemplate, this, name);
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    public boolean queryReturnsRows(String query, String ... params) throws SQLException {
        return this.jdbcTemplate.queryForBoolean("SELECT CASE WHEN EXISTS(" + query + ") THEN 1 ELSE 0 END FROM DUAL", params);
    }

    public boolean isDbaDataDictAccessible() throws SQLException {
        return this.queryReturnsRows("SELECT 1 FROM SESSION_PRIVS WHERE PRIVILEGE = 'SELECT ANY DICTIONARY' UNION ALL SELECT 1 FROM SESSION_ROLES WHERE ROLE = 'SELECT_CATALOG_ROLE'", new String[0]);
    }

    public boolean isDataDictViewAccessible(String owner, String name) throws SQLException {
        return this.queryReturnsRows("SELECT * FROM ALL_TAB_PRIVS WHERE TABLE_SCHEMA = ? AND TABLE_NAME= ? AND PRIVILEGE = 'SELECT'", owner, name);
    }

    public boolean isDataDictViewAccessible(String name) throws SQLException {
        return this.isDataDictViewAccessible("SYS", name);
    }

    public Set<String> getAvailableOptions() throws SQLException {
        return new HashSet<String>(this.jdbcTemplate.queryForStringList("SELECT PARAMETER FROM V$OPTION WHERE VALUE = 'TRUE'", new String[0]));
    }

    public boolean isFlashbackDataArchiveAvailable() throws SQLException {
        return this.getAvailableOptions().contains("Flashback Data Archive");
    }

    public boolean isXmlDbAvailable() throws SQLException {
        return this.isDataDictViewAccessible("ALL_XML_TABLES");
    }

    public boolean isLocatorAvailable() throws SQLException {
        return this.isDataDictViewAccessible("MDSYS", "ALL_SDO_GEOM_METADATA");
    }

    public Set<String> getSystemSchemas() throws SQLException {
        HashSet<String> result = new HashSet<String>(Arrays.asList("SYS", "SYSTEM", "SYSBACKUP", "SYSDG", "SYSKM", "SYSRAC", "SYS$UMF", "DBSNMP", "MGMT_VIEW", "SYSMAN", "OUTLN", "AUDSYS", "ORACLE_OCM", "APPQOSSYS", "OJVMSYS", "DVF", "DVSYS", "DBSFWUSER", "REMOTE_SCHEDULER_AGENT", "DIP", "APEX_PUBLIC_USER", "FLOWS_FILES", "ANONYMOUS", "XDB", "XS$NULL", "CTXSYS", "LBACSYS", "EXFSYS", "MDDATA", "MDSYS", "SPATIAL_CSW_ADMIN_USR", "SPATIAL_WFS_ADMIN_USR", "ORDDATA", "ORDPLUGINS", "ORDSYS", "SI_INFORMTN_SCHEMA", "WMSYS", "OLAPSYS", "OWBSYS", "OWBSYS_AUDIT", "GSMADMIN_INTERNAL", "GSMCATUSER", "GSMUSER", "GGSYS", "WK_TEST", "WKSYS", "WKPROXY", "ODM", "ODM_MTR", "DMSYS", "TSMSYS"));
        boolean oracle12cOrHigher = this.jdbcTemplate.getMetaData().getDatabaseMajorVersion() >= 12;
        result.addAll(this.jdbcTemplate.queryForStringList("SELECT USERNAME FROM ALL_USERS WHERE REGEXP_LIKE(USERNAME, '^(APEX|FLOWS)_\\d+$')" + (oracle12cOrHigher ? " OR ORACLE_MAINTAINED = 'Y'" : ""), new String[0]));
        if (!oracle12cOrHigher && this.isDataDictViewAccessible("DBA_REGISTRY")) {
            List<List<String>> schemaSuperList = this.jdbcTemplate.query("SELECT SCHEMA, OTHER_SCHEMAS FROM DBA_REGISTRY", new RowMapper<List<String>>(){

                @Override
                public List<String> mapRow(ResultSet rs) throws SQLException {
                    ArrayList<String> schemaList = new ArrayList<String>();
                    schemaList.add(rs.getString("SCHEMA"));
                    String otherSchemas = rs.getString("OTHER_SCHEMAS");
                    if (otherSchemas != null && !otherSchemas.trim().isEmpty()) {
                        schemaList.addAll(Arrays.asList(otherSchemas.trim().split("\\s*,\\s*")));
                    }
                    return schemaList;
                }
            });
            for (List<String> schemaList : schemaSuperList) {
                result.addAll(schemaList);
            }
        }
        return result;
    }
}

