/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.db2;

import org.flywaydb.core.internal.dbsupport.Delimiter;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;

public class DB2SqlStatementBuilder
extends SqlStatementBuilder {
    private static final String DELIMITER_KEYWORD = "--#SET TERMINATOR";
    private boolean insideBeginEndBlock;
    private String statementStart = "";
    private Delimiter currentDelimiter = this.getDefaultDelimiter();

    @Override
    public Delimiter extractNewDelimiterFromLine(String line) {
        if (line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
            this.currentDelimiter = new Delimiter(line.substring(DELIMITER_KEYWORD.length()).trim(), false);
            return this.currentDelimiter;
        }
        return null;
    }

    @Override
    protected boolean isSingleLineComment(String line) {
        return line.startsWith("--") && !line.startsWith(DELIMITER_KEYWORD);
    }

    @Override
    protected String cleanToken(String token) {
        if (token.startsWith("X'")) {
            return token.substring(token.indexOf("'"));
        }
        return super.cleanToken(token);
    }

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (StringUtils.countOccurrencesOf(this.statementStart, " ") < 4) {
            this.statementStart = this.statementStart + line;
            this.statementStart = this.statementStart + " ";
        }
        if (this.statementStart.startsWith("CREATE FUNCTION") || this.statementStart.startsWith("CREATE PROCEDURE") || this.statementStart.startsWith("CREATE TRIGGER") || this.statementStart.startsWith("CREATE OR REPLACE FUNCTION") || this.statementStart.startsWith("CREATE OR REPLACE PROCEDURE") || this.statementStart.startsWith("CREATE OR REPLACE TRIGGER")) {
            if (line.startsWith("BEGIN")) {
                this.insideBeginEndBlock = true;
            }
            if (line.endsWith("END;")) {
                this.insideBeginEndBlock = false;
            }
        }
        if (this.insideBeginEndBlock) {
            return null;
        }
        return this.currentDelimiter;
    }
}

