/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import org.flywaydb.core.internal.resolver.jdbc.JdbcMigrationResolver;
import org.flywaydb.core.internal.resolver.spring.SpringJdbcMigrationResolver;
import org.flywaydb.core.internal.resolver.sql.SqlMigrationResolver;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.Location;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.Scanner;

public class CompositeMigrationResolver
implements MigrationResolver {
    private Collection<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>();
    private List<ResolvedMigration> availableMigrations;

    public CompositeMigrationResolver(DbSupport dbSupport, Scanner scanner, FlywayConfiguration configuration, Locations locations, PlaceholderReplacer placeholderReplacer, MigrationResolver ... customMigrationResolvers) {
        if (!configuration.isSkipDefaultResolvers()) {
            for (Location location : locations.getLocations()) {
                this.migrationResolvers.add(new SqlMigrationResolver(dbSupport, scanner, location, placeholderReplacer, configuration));
                this.migrationResolvers.add(new JdbcMigrationResolver(scanner, location, configuration));
                if (!new FeatureDetector(scanner.getClassLoader()).isSpringJdbcAvailable()) continue;
                this.migrationResolvers.add(new SpringJdbcMigrationResolver(scanner, location, configuration));
            }
        }
        this.migrationResolvers.addAll(Arrays.asList(customMigrationResolvers));
    }

    public List<ResolvedMigration> resolveMigrations() {
        if (this.availableMigrations == null) {
            this.availableMigrations = this.doFindAvailableMigrations();
        }
        return this.availableMigrations;
    }

    private List<ResolvedMigration> doFindAvailableMigrations() throws FlywayException {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>(CompositeMigrationResolver.collectMigrations(this.migrationResolvers));
        Collections.sort(migrations, new ResolvedMigrationComparator());
        CompositeMigrationResolver.checkForIncompatibilities(migrations);
        return migrations;
    }

    static Collection<ResolvedMigration> collectMigrations(Collection<MigrationResolver> migrationResolvers) {
        HashSet<ResolvedMigration> migrations = new HashSet<ResolvedMigration>();
        for (MigrationResolver migrationResolver : migrationResolvers) {
            migrations.addAll(migrationResolver.resolveMigrations());
        }
        return migrations;
    }

    static void checkForIncompatibilities(List<ResolvedMigration> migrations) {
        for (int i = 0; i < migrations.size() - 1; ++i) {
            ResolvedMigration next;
            ResolvedMigration current = migrations.get(i);
            if (new ResolvedMigrationComparator().compare(current, next = migrations.get(i + 1)) != 0) continue;
            if (current.getVersion() != null) {
                throw new FlywayException(String.format("Found more than one migration with version %s\nOffenders:\n-> %s (%s)\n-> %s (%s)", new Object[]{current.getVersion(), current.getPhysicalLocation(), current.getType(), next.getPhysicalLocation(), next.getType()}));
            }
            throw new FlywayException(String.format("Found more than one repeatable migration with description %s\nOffenders:\n-> %s (%s)\n-> %s (%s)", new Object[]{current.getDescription(), current.getPhysicalLocation(), current.getType(), next.getPhysicalLocation(), next.getType()}));
        }
    }
}

