/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.lang.module.ModuleDescriptor;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.VersionUtils;

public class DeprecationUtils {
    @Generated
    private static final Log LOG = LogFactory.getLog(DeprecationUtils.class);

    public static void throwUnsupportedIfLaterThanOrEquivalentTo(DeprecatedFeatures feature) {
        String versionOverride = System.getenv("FLYWAY_NEXT_MAJOR_VERSION");
        ModuleDescriptor.Version currentVersion = ModuleDescriptor.Version.parse(versionOverride != null ? versionOverride : VersionPrinter.getVersion());
        if (feature.version != null && VersionUtils.currentVersionIsHigherThanOrEquivalentTo(currentVersion, ModuleDescriptor.Version.parse(String.valueOf(feature.version)))) {
            throw new FlywayException(feature.feature + " is no longer supported");
        }
        DeprecationUtils.printDeprecationNotice(feature);
    }

    public static void printDeprecationNotice(DeprecatedFeatures feature) {
        String message = feature.feature + " is deprecated and will be removed in a future release." + (String)(feature.replacement != null ? "Please use " + feature.replacement + " instead" : "");
        LOG.warn(message);
    }

    public static enum DeprecatedFeatures {
        CLONE_PROVISIONER("Clone Provisioner", null, 13),
        CLONE_RESOLVER("Clone Resolver", null, 13),
        CHECK_BUILD_URL("check.buildUrl", "check.buildEnvironment", null),
        CREATE_SCHEMA("'createSchema' callback", "beforeCreateSchema", null),
        MONGODB_URL("jdbc:mongodb:// URL prefix", "mongodb://", null);

        private final String feature;
        private final String replacement;
        private final Integer version;

        private DeprecatedFeatures(String feature, String replacement, Integer removalVersion) {
            this.feature = feature;
            this.replacement = replacement;
            this.version = removalVersion;
        }
    }
}

