/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.logging;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.logging.JsonLogModel;
import org.flywaydb.core.internal.logging.LogLevel;
import org.flywaydb.core.internal.util.JsonUtils;

public class JsonLog
implements Log {
    private JsonMapper mapper;

    private JsonMapper getJsonMapper() {
        if (this.mapper == null) {
            this.mapper = JsonUtils.getJsonMapper();
            this.mapper.disable(SerializationFeature.INDENT_OUTPUT);
        }
        return this.mapper;
    }

    private void write(String message, LogLevel level) throws JacksonException {
        String[] lines;
        for (String line : lines = message.split("\n")) {
            System.err.println(this.getJsonMapper().writeValueAsString((Object)new JsonLogModel(level, line)));
        }
    }

    @Override
    public void debug(String message) {
        if (LogFactory.isJsonLogsEnabled() && LogFactory.isDebugEnabled()) {
            this.write(message, LogLevel.DEBUG);
        }
    }

    @Override
    public void info(String message) {
        if (LogFactory.isJsonLogsEnabled()) {
            this.write(message, LogLevel.INFO);
        }
    }

    @Override
    public void warn(String message) {
        if (LogFactory.isJsonLogsEnabled()) {
            this.write(message, LogLevel.WARN);
        }
    }

    @Override
    public void error(String message) {
        if (LogFactory.isJsonLogsEnabled()) {
            this.write(message, LogLevel.ERROR);
        }
    }

    @Override
    public void error(String message, Exception e) {
        if (LogFactory.isJsonLogsEnabled()) {
            this.write(message + " Exception: " + e.getMessage(), LogLevel.ERROR);
        }
    }

    @Override
    public void notice(String message) {
        if (LogFactory.isJsonLogsEnabled()) {
            System.err.println(this.getJsonMapper().writeValueAsString((Object)new JsonLogModel(LogLevel.NOTICE, message)));
        }
    }
}

