/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.models;

import java.util.List;
import java.util.Map;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.configuration.models.FlywayEnvironmentModel;
import org.flywaydb.core.internal.util.StringUtils;

public record UnknownParameterModel(String rawKey, Reason reason, Source source, List<String> possibleValues, String replacement) {
    private static final String CLEAN_ON_VALIDATION_ERROR = "flyway.cleanOnValidationError";
    private static final Map<String, String> MOVED_OR_REMOVED_PARAMS = Map.ofEntries(Map.entry("flyway.cleanOnValidationError", ""));

    public static UnknownParameterModel resolveUnknownParameter(FlywayEnvironmentModel model, String namespace, String key, String prefix) {
        String rawKey = prefix + key;
        String configKey = namespace + "." + key;
        if (MOVED_OR_REMOVED_PARAMS.containsKey(configKey)) {
            String replacement = MOVED_OR_REMOVED_PARAMS.get(configKey);
            if (StringUtils.hasText(replacement)) {
                return new UnknownParameterModel(rawKey, Reason.REPLACED, null, null, replacement);
            }
            return new UnknownParameterModel(rawKey, Reason.REMOVED, null, null, replacement);
        }
        List<String> possibleConfigurations = ConfigUtils.getPossibleFlywayConfigurations(key, model, prefix);
        if (!possibleConfigurations.isEmpty()) {
            return new UnknownParameterModel(rawKey, Reason.UNKNOWN, null, possibleConfigurations, null);
        }
        return new UnknownParameterModel(rawKey, Reason.UNKNOWN, null, null, null);
    }

    @Override
    public String toString() {
        return switch (this.reason.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "\tDeprecated: '" + this.rawKey + "' has been replaced by '" + this.replacement + "'.";
            case 1 -> "\tRemoved: '" + this.rawKey + "' has been removed and is no longer supported.";
            case 2 -> this.possibleValues != null && !this.possibleValues.isEmpty() ? "\tUnknown: '" + this.rawKey + "'. Possible values: " + String.join((CharSequence)", ", this.possibleValues) + "?" : "\tUnknown: '" + this.rawKey + "'. Check the parameter spelling and ensure Flyway is up to date.";
        };
    }

    public static enum Reason {
        REPLACED,
        REMOVED,
        UNKNOWN;

    }

    public static enum Source {
        TOML,
        CLI,
        ENV;

    }
}

