/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.models;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.resolvers.ProvisionerMode;

public class ResolvedEnvironment {
    private String url;
    private String user;
    private String password;
    private String driver;
    private List<String> schemas = List.of();
    private String token;
    private Integer connectRetries;
    private Integer connectRetriesInterval;
    private String initSql;
    private Map<String, String> jdbcProperties = Map.of();
    private ProvisionerMode provisionerMode;
    private String nativeUrl;

    public ResolvedEnvironment() {
    }

    public EnvironmentModel toEnvironmentModel() {
        EnvironmentModel result = new EnvironmentModel();
        result.setUrl(this.url);
        result.setPassword(this.password);
        result.setUser(this.user);
        result.setDriver(this.driver);
        result.setSchemas(this.schemas);
        result.setConnectRetries(this.connectRetries);
        result.setConnectRetriesInterval(this.connectRetriesInterval);
        result.setInitSql(this.initSql);
        result.setJdbcProperties(this.jdbcProperties);
        result.setResolvers(Map.of());
        result.setProvisioner("none");
        return result;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getDriver() {
        return this.driver;
    }

    @Generated
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public Integer getConnectRetries() {
        return this.connectRetries;
    }

    @Generated
    public Integer getConnectRetriesInterval() {
        return this.connectRetriesInterval;
    }

    @Generated
    public String getInitSql() {
        return this.initSql;
    }

    @Generated
    public Map<String, String> getJdbcProperties() {
        return this.jdbcProperties;
    }

    @Generated
    public ProvisionerMode getProvisionerMode() {
        return this.provisionerMode;
    }

    @Generated
    public String getNativeUrl() {
        return this.nativeUrl;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setDriver(String driver) {
        this.driver = driver;
    }

    @Generated
    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setConnectRetries(Integer connectRetries) {
        this.connectRetries = connectRetries;
    }

    @Generated
    public void setConnectRetriesInterval(Integer connectRetriesInterval) {
        this.connectRetriesInterval = connectRetriesInterval;
    }

    @Generated
    public void setInitSql(String initSql) {
        this.initSql = initSql;
    }

    @Generated
    public void setJdbcProperties(Map<String, String> jdbcProperties) {
        this.jdbcProperties = jdbcProperties;
    }

    @Generated
    public void setProvisionerMode(ProvisionerMode provisionerMode) {
        this.provisionerMode = provisionerMode;
    }

    @Generated
    public void setNativeUrl(String nativeUrl) {
        this.nativeUrl = nativeUrl;
    }

    @Generated
    public ResolvedEnvironment withUrl(String url) {
        return this.url == url ? this : new ResolvedEnvironment(url, this.user, this.password, this.driver, this.schemas, this.token, this.connectRetries, this.connectRetriesInterval, this.initSql, this.jdbcProperties, this.provisionerMode, this.nativeUrl);
    }

    @Generated
    public ResolvedEnvironment withUser(String user) {
        return this.user == user ? this : new ResolvedEnvironment(this.url, user, this.password, this.driver, this.schemas, this.token, this.connectRetries, this.connectRetriesInterval, this.initSql, this.jdbcProperties, this.provisionerMode, this.nativeUrl);
    }

    @Generated
    public ResolvedEnvironment withPassword(String password) {
        return this.password == password ? this : new ResolvedEnvironment(this.url, this.user, password, this.driver, this.schemas, this.token, this.connectRetries, this.connectRetriesInterval, this.initSql, this.jdbcProperties, this.provisionerMode, this.nativeUrl);
    }

    @Generated
    public ResolvedEnvironment withDriver(String driver) {
        return this.driver == driver ? this : new ResolvedEnvironment(this.url, this.user, this.password, driver, this.schemas, this.token, this.connectRetries, this.connectRetriesInterval, this.initSql, this.jdbcProperties, this.provisionerMode, this.nativeUrl);
    }

    @Generated
    public ResolvedEnvironment withSchemas(List<String> schemas) {
        return this.schemas == schemas ? this : new ResolvedEnvironment(this.url, this.user, this.password, this.driver, schemas, this.token, this.connectRetries, this.connectRetriesInterval, this.initSql, this.jdbcProperties, this.provisionerMode, this.nativeUrl);
    }

    @Generated
    public ResolvedEnvironment withToken(String token) {
        return this.token == token ? this : new ResolvedEnvironment(this.url, this.user, this.password, this.driver, this.schemas, token, this.connectRetries, this.connectRetriesInterval, this.initSql, this.jdbcProperties, this.provisionerMode, this.nativeUrl);
    }

    @Generated
    public ResolvedEnvironment withConnectRetries(Integer connectRetries) {
        return this.connectRetries == connectRetries ? this : new ResolvedEnvironment(this.url, this.user, this.password, this.driver, this.schemas, this.token, connectRetries, this.connectRetriesInterval, this.initSql, this.jdbcProperties, this.provisionerMode, this.nativeUrl);
    }

    @Generated
    public ResolvedEnvironment withConnectRetriesInterval(Integer connectRetriesInterval) {
        return this.connectRetriesInterval == connectRetriesInterval ? this : new ResolvedEnvironment(this.url, this.user, this.password, this.driver, this.schemas, this.token, this.connectRetries, connectRetriesInterval, this.initSql, this.jdbcProperties, this.provisionerMode, this.nativeUrl);
    }

    @Generated
    public ResolvedEnvironment withInitSql(String initSql) {
        return this.initSql == initSql ? this : new ResolvedEnvironment(this.url, this.user, this.password, this.driver, this.schemas, this.token, this.connectRetries, this.connectRetriesInterval, initSql, this.jdbcProperties, this.provisionerMode, this.nativeUrl);
    }

    @Generated
    public ResolvedEnvironment withJdbcProperties(Map<String, String> jdbcProperties) {
        return this.jdbcProperties == jdbcProperties ? this : new ResolvedEnvironment(this.url, this.user, this.password, this.driver, this.schemas, this.token, this.connectRetries, this.connectRetriesInterval, this.initSql, jdbcProperties, this.provisionerMode, this.nativeUrl);
    }

    @Generated
    public ResolvedEnvironment withProvisionerMode(ProvisionerMode provisionerMode) {
        return this.provisionerMode == provisionerMode ? this : new ResolvedEnvironment(this.url, this.user, this.password, this.driver, this.schemas, this.token, this.connectRetries, this.connectRetriesInterval, this.initSql, this.jdbcProperties, provisionerMode, this.nativeUrl);
    }

    @Generated
    public ResolvedEnvironment withNativeUrl(String nativeUrl) {
        return this.nativeUrl == nativeUrl ? this : new ResolvedEnvironment(this.url, this.user, this.password, this.driver, this.schemas, this.token, this.connectRetries, this.connectRetriesInterval, this.initSql, this.jdbcProperties, this.provisionerMode, nativeUrl);
    }

    @Generated
    public ResolvedEnvironment(String url, String user, String password, String driver, List<String> schemas, String token, Integer connectRetries, Integer connectRetriesInterval, String initSql, Map<String, String> jdbcProperties, ProvisionerMode provisionerMode, String nativeUrl) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.driver = driver;
        this.schemas = schemas;
        this.token = token;
        this.connectRetries = connectRetries;
        this.connectRetriesInterval = connectRetriesInterval;
        this.initSql = initSql;
        this.jdbcProperties = jdbcProperties;
        this.provisionerMode = provisionerMode;
        this.nativeUrl = nativeUrl;
    }
}

