/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.license.FlywayEditionUpgradeRequiredException;

public class UrlUtils {
    public static String toFilePath(URL url) {
        String filePath = new File(UrlUtils.decodeURLSafe(url.getPath())).getAbsolutePath();
        if (filePath.endsWith("/")) {
            return filePath.substring(0, filePath.length() - 1);
        }
        return filePath;
    }

    public static String decodeURL(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Can never happen", e);
        }
    }

    public static String decodeURLSafe(String url) {
        return UrlUtils.decodeURL(url.replace("+", "%2b"));
    }

    public static boolean isSecretManagerUrl(String url, String databaseType) {
        if (url.startsWith("jdbc-secretsmanager:" + databaseType + ":")) {
            throw new FlywayEditionUpgradeRequiredException((Tier)null, "jdbc-secretsmanager");
        }
        return false;
    }

    public static boolean isAwsWrapperUrl(String url, String databaseType) {
        return url.startsWith("jdbc:aws-wrapper:" + databaseType + ":");
    }

    public static Map<String, String> extractQueryParams(String uri) {
        uri = uri.replace('\\', '/');
        try {
            int queryIndex = uri.indexOf("?");
            if (queryIndex == -1) {
                return Collections.emptyMap();
            }
            String baseUri = uri.substring(0, queryIndex);
            String queryPart = uri.substring(queryIndex + 1);
            String encodedQuery = URLEncoder.encode(queryPart, StandardCharsets.UTF_8);
            URI parsedUri = new URI(baseUri + "?" + encodedQuery);
            String query = parsedUri.getQuery();
            HashMap<String, String> queryParams = new HashMap<String, String>();
            if (query != null) {
                String[] pairs;
                for (String pair : pairs = query.split("&")) {
                    String[] keyValue = pair.split("=", 2);
                    if (keyValue.length != 2) continue;
                    queryParams.put(keyValue[0], keyValue[1]);
                }
            }
            return queryParams;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    private UrlUtils() {
    }
}

