/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.proprietaryStubs;

import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.TelemetrySpan;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.internal.license.FlywayRedgateEditionRequiredException;

public class CommandExtensionStub
implements CommandExtension {
    private static final Log LOG = LogFactory.getLog(CommandExtensionStub.class);
    public static final List<String> COMMANDS = Arrays.asList("check", "undo");

    @Override
    public boolean handlesCommand(String command) {
        return COMMANDS.contains(command);
    }

    @Override
    public boolean handlesParameter(String parameter) {
        return false;
    }

    @Override
    public OperationResult handle(String command, Configuration config, List<String> flags, FlywayTelemetryManager flywayTelemetryManager) throws FlywayException {
        return TelemetrySpan.trackSpan(new EventTelemetryModel(command, flywayTelemetryManager), telemetryModel -> {
            throw new FlywayRedgateEditionRequiredException(command);
        });
    }

    @Override
    public String getDescription() {
        return "Produces reports to increase confidence in your migrations";
    }

    @Override
    public int getPriority() {
        return -100;
    }
}

