/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.booleanexpression;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.booleanexpression.ASTNodes;

public class ASTEvaluator {
    private static final Map<Class<? extends ASTNodes.Expression>, Function<ASTNodes.Expression, Boolean>> EVALUATORS = Map.of(ASTNodes.ComparisonExpression.class, e -> ASTEvaluator.evaluate((ASTNodes.ComparisonExpression)e), ASTNodes.WordComparisonExpression.class, e -> ASTEvaluator.evaluate((ASTNodes.WordComparisonExpression)e), ASTNodes.WordExpressionComparisonExpression.class, e -> ASTEvaluator.evaluate((ASTNodes.WordExpressionComparisonExpression)e), ASTNodes.LogicalExpression.class, e -> ASTEvaluator.evaluate((ASTNodes.LogicalExpression)e), ASTNodes.BooleanNode.class, e -> ASTEvaluator.evaluate((ASTNodes.BooleanNode)e));

    private static boolean evaluate(ASTNodes.ComparisonExpression expression) {
        return switch ((ASTNodes.Comparator)((Object)expression.getOperator())) {
            default -> throw new IncompatibleClassChangeError();
            case ASTNodes.Comparator.EQUAL -> {
                if (ASTEvaluator.evaluate(expression.getLeft()) == ASTEvaluator.evaluate(expression.getRight())) {
                    yield true;
                }
                yield false;
            }
            case ASTNodes.Comparator.NOT_EQUAL -> ASTEvaluator.evaluate(expression.getLeft()) != ASTEvaluator.evaluate(expression.getRight());
        };
    }

    private static boolean evaluate(ASTNodes.WordComparisonExpression expression) {
        boolean areEqual = Objects.equals(expression.leftWord().word(), expression.rightWord().word());
        return switch (expression.comparator()) {
            default -> throw new IncompatibleClassChangeError();
            case ASTNodes.Comparator.EQUAL -> areEqual;
            case ASTNodes.Comparator.NOT_EQUAL -> !areEqual;
        };
    }

    private static boolean evaluate(ASTNodes.WordExpressionComparisonExpression expression) {
        String expressionValue = Boolean.toString(ASTEvaluator.evaluate(expression.expression()));
        String wordValue = expression.word().word().toLowerCase(Locale.ROOT);
        boolean areEqual = Objects.equals(expressionValue, wordValue);
        return switch (expression.comparator()) {
            default -> throw new IncompatibleClassChangeError();
            case ASTNodes.Comparator.EQUAL -> areEqual;
            case ASTNodes.Comparator.NOT_EQUAL -> !areEqual;
        };
    }

    private static boolean evaluate(ASTNodes.LogicalExpression expression) {
        return switch ((ASTNodes.LogicalOperator)((Object)expression.getOperator())) {
            default -> throw new IncompatibleClassChangeError();
            case ASTNodes.LogicalOperator.AND -> {
                if (ASTEvaluator.evaluate(expression.getLeft()) && ASTEvaluator.evaluate(expression.getRight())) {
                    yield true;
                }
                yield false;
            }
            case ASTNodes.LogicalOperator.OR -> ASTEvaluator.evaluate(expression.getLeft()) || ASTEvaluator.evaluate(expression.getRight());
        };
    }

    private static boolean evaluate(ASTNodes.BooleanNode expression) {
        return expression.value();
    }

    public static boolean evaluate(ASTNodes.Expression expression) {
        return Optional.ofNullable(EVALUATORS.get(expression.getClass())).orElseThrow(() -> new FlywayException("No matching expression evaluator found for class: " + String.valueOf(expression.getClass()), CoreErrorCode.FAULT)).apply(expression);
    }

    private ASTEvaluator() {
    }
}

