/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.license;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import lombok.Generated;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.DateUtils;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class FlywayPermit
implements Serializable {
    @Generated
    private static final Log LOG = LogFactory.getLog(FlywayPermit.class);
    private String owner;
    private Date permitExpiry;
    private Date contractExpiry;
    private Tier tier;
    private boolean trial;
    private boolean redgateEmployee;
    private boolean fromAuth;
    private final long DAYS_TO_DISPLAY_LICENSED_UNTIL = 30L;
    static final long PERMIT_FILE_OUTDATED_TIME = 86400000L;
    private static final File FLYWAY_APP_DATA_FOLDER = FileUtils.getAppDataFlywayCLILocation();
    private static final File PERMIT_FILE = new File(FLYWAY_APP_DATA_FOLDER, "permit");
    private static final File REFRESH_TOKEN_FILE = new File(FLYWAY_APP_DATA_FOLDER, "refresh_token");

    public FlywayPermit(String owner, Date permitExpiry, Date contractExpiry, boolean trial, boolean redgateEmployee, boolean fromAuth) {
        this.owner = owner;
        this.permitExpiry = permitExpiry;
        this.contractExpiry = contractExpiry;
        this.trial = trial;
        this.redgateEmployee = redgateEmployee;
        this.fromAuth = fromAuth;
    }

    public void print() {
        if (this.tier == null) {
            LOG.info("Flyway OSS Edition " + VersionPrinter.getVersion() + " by Redgate");
            LOG.info("");
            return;
        }
        LOG.info("Flyway " + this.tier.getDisplayName() + " Edition " + VersionPrinter.getVersion() + " by Redgate");
        if (this.contractExpiry != null) {
            if ("Online User".equals(this.owner)) {
                if (this.contractExpiry.getTime() == Long.MAX_VALUE) {
                    LOG.debug("License has no expiry date");
                } else {
                    this.logLicensedUntilIfWithinWindow();
                }
            } else if (!"Anonymous".equals(this.owner)) {
                LOG.info("Licensed to " + this.owner);
                this.logLicensedUntilIfWithinWindow();
            }
        }
        if (!REFRESH_TOKEN_FILE.exists() && PERMIT_FILE.exists() && this.fromAuth) {
            if (FlywayPermit.permitFileOutdated(PERMIT_FILE)) {
                LOG.info("Flyway permit on disk is outdated and cannot be refreshed automatically because there is no refresh token on disk. Please rerun auth");
            } else if (this.permitExpired()) {
                LOG.info("Flyway permit on disk is expired and cannot be refreshed automatically because there is no refresh token on disk. Please rerun auth");
            }
        }
        if (this.tier == Tier.COMMUNITY && PERMIT_FILE.exists()) {
            LOG.info("No Flyway license detected for this user - using Community Edition. If you expected a Teams/Enterprise license then please add a Flyway license to your account and rerun auth. Alternatively, you can run auth -logout to remove your unlicensed permit on disk");
        }
        if (this.isTrial()) {
            LOG.warn("You are using a limited Flyway trial license, valid until " + DateUtils.toDateString(this.contractExpiry) + ". In " + StringUtils.getDaysString(DateUtils.getRemainingDays(this.contractExpiry)) + " you must either upgrade to a full " + this.tier.getDisplayName() + " license or downgrade to " + Tier.COMMUNITY.getDisplayName() + ".");
        }
        LOG.info("");
    }

    private void logLicensedUntilIfWithinWindow() {
        if (DateUtils.getRemainingDays(this.contractExpiry) <= 30L) {
            LOG.info("Licensed until " + DateUtils.toDateString(this.contractExpiry) + " (" + StringUtils.getDaysString(DateUtils.getRemainingDays(this.contractExpiry)) + " remaining)");
        }
    }

    public static boolean permitFileOutdated(File permitFile) {
        return permitFile.lastModified() + 86400000L < new Date().getTime();
    }

    public boolean permitExpired() {
        return this.permitExpiry == null || this.permitExpiry.before(new Date());
    }

    public boolean contractExpired() {
        return this.contractExpiry == null || this.contractExpiry.before(new Date());
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public Date getPermitExpiry() {
        return this.permitExpiry;
    }

    @Generated
    public Date getContractExpiry() {
        return this.contractExpiry;
    }

    @Generated
    public Tier getTier() {
        return this.tier;
    }

    @Generated
    public boolean isTrial() {
        return this.trial;
    }

    @Generated
    public boolean isRedgateEmployee() {
        return this.redgateEmployee;
    }

    @Generated
    public boolean isFromAuth() {
        return this.fromAuth;
    }

    @Generated
    public long getDAYS_TO_DISPLAY_LICENSED_UNTIL() {
        return this.DAYS_TO_DISPLAY_LICENSED_UNTIL;
    }
}

