/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.logging;

import java.util.Arrays;
import java.util.stream.Collectors;
import lombok.Generated;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;
import org.flywaydb.core.api.logging.LogLevel;
import org.flywaydb.core.internal.logging.EvolvingLog;
import org.flywaydb.core.internal.logging.apachecommons.ApacheCommonsLogCreator;
import org.flywaydb.core.internal.logging.buffered.BufferedLogCreator;
import org.flywaydb.core.internal.logging.javautil.JavaUtilLogCreator;
import org.flywaydb.core.internal.logging.log4j2.Log4j2LogCreator;
import org.flywaydb.core.internal.logging.multi.MultiLogCreator;
import org.flywaydb.core.internal.logging.slf4j.Slf4jLogCreator;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.FeatureDetector;

public class LogFactory {
    @Generated
    private static final Object $LOCK = new Object[0];
    private static volatile LogCreator logCreator;
    private static LogCreator fallbackLogCreator;
    private static Configuration configuration;
    private static LogLevel logLevel;

    public static boolean isDebugEnabled() {
        return logLevel == LogLevel.DEBUG;
    }

    public static boolean isQuietMode() {
        return logLevel == LogLevel.WARN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfiguration(Configuration configuration) {
        Object object = $LOCK;
        synchronized (object) {
            LogFactory.configuration = configuration;
            logCreator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log getLog(Class<?> clazz) {
        Object object = $LOCK;
        synchronized (object) {
            if (logCreator == null) {
                logCreator = LogFactory.getLogCreator(LogFactory.class.getClassLoader(), fallbackLogCreator);
            }
            return new EvolvingLog(logCreator.createLogger(clazz), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LogCreator getLogCreator(ClassLoader classLoader, LogCreator fallbackLogCreator) {
        Object object = $LOCK;
        synchronized (object) {
            if (configuration == null) {
                return new BufferedLogCreator();
            }
            return new MultiLogCreator(Arrays.stream(configuration.getLoggers()).map(logger -> switch (logger) {
                case "auto" -> LogFactory.autoDetectLogCreator(classLoader, fallbackLogCreator);
                case "maven", "console" -> fallbackLogCreator;
                case "slf4j" -> (LogCreator)ClassUtils.instantiate(Slf4jLogCreator.class.getName(), classLoader);
                case "log4j2" -> (LogCreator)ClassUtils.instantiate(Log4j2LogCreator.class.getName(), classLoader);
                case "apache-commons" -> (LogCreator)ClassUtils.instantiate(ApacheCommonsLogCreator.class.getName(), classLoader);
                default -> (LogCreator)ClassUtils.instantiate(logger, classLoader);
            }).collect(Collectors.toList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LogCreator autoDetectLogCreator(ClassLoader classLoader, LogCreator fallbackLogCreator) {
        Object object = $LOCK;
        synchronized (object) {
            FeatureDetector featureDetector = new FeatureDetector(classLoader);
            if (featureDetector.isSlf4jAvailable()) {
                return (LogCreator)ClassUtils.instantiate(Slf4jLogCreator.class.getName(), classLoader);
            }
            if (featureDetector.isLog4J2Available()) {
                return (LogCreator)ClassUtils.instantiate(Log4j2LogCreator.class.getName(), classLoader);
            }
            if (featureDetector.isApacheCommonsLoggingAvailable()) {
                return (LogCreator)ClassUtils.instantiate(ApacheCommonsLogCreator.class.getName(), classLoader);
            }
            if (fallbackLogCreator == null) {
                return new JavaUtilLogCreator();
            }
            return fallbackLogCreator;
        }
    }

    @Generated
    private LogFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static void setLogCreator(LogCreator logCreator) {
        Object object = $LOCK;
        synchronized (object) {
            LogFactory.logCreator = logCreator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static void setFallbackLogCreator(LogCreator fallbackLogCreator) {
        Object object = $LOCK;
        synchronized (object) {
            LogFactory.fallbackLogCreator = fallbackLogCreator;
        }
    }

    @Generated
    public static LogLevel getLogLevel() {
        return logLevel;
    }

    @Generated
    public static void setLogLevel(LogLevel logLevel) {
        LogFactory.logLevel = logLevel;
    }
}

