/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.flywaydb.core.api.callback.Error;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.callback.Warning;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.exception.FlywayBlockStatementExecutionException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.sqlscript.FlywaySqlScriptException;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatementIterator;
import org.flywaydb.core.internal.util.AsciiTable;
import org.flywaydb.core.internal.util.StringUtils;

public class DefaultSqlScriptExecutor
implements SqlScriptExecutor {
    @Generated
    private static final Log LOG = LogFactory.getLog(DefaultSqlScriptExecutor.class);
    protected final JdbcTemplate jdbcTemplate;
    private final CallbackExecutor<Event> callbackExecutor;
    private static final int MAX_BATCH_SIZE = 100;
    private final boolean batch;
    protected final boolean outputQueryResults;

    public DefaultSqlScriptExecutor(JdbcTemplate jdbcTemplate, CallbackExecutor<Event> callbackExecutor, boolean undo, boolean batch, boolean outputQueryResults, StatementInterceptor statementInterceptor) {
        this.jdbcTemplate = jdbcTemplate;
        this.callbackExecutor = callbackExecutor;
        this.outputQueryResults = outputQueryResults;
        this.batch = batch;
    }

    @Override
    public List<Results> execute(SqlScript sqlScript, Configuration config) {
        ArrayList<Results> results = new ArrayList<Results>(List.of());
        ArrayList<SqlStatement> batchStatements = new ArrayList<SqlStatement>();
        try (SqlStatementIterator sqlStatementIterator = sqlScript.getSqlStatements();){
            SqlStatement sqlStatement;
            while ((sqlStatement = (SqlStatement)sqlStatementIterator.next()) != null) {
                if (this.batch) {
                    if (sqlStatement.isBatchable()) {
                        this.logStatementExecution(sqlStatement);
                        batchStatements.add(sqlStatement);
                        if (batchStatements.size() < 100) continue;
                        results.add(this.executeBatch(this.jdbcTemplate, sqlScript, batchStatements, config));
                        batchStatements = new ArrayList();
                        continue;
                    }
                    results.add(this.executeBatch(this.jdbcTemplate, sqlScript, batchStatements, config));
                    batchStatements = new ArrayList();
                    results.add(this.executeStatement(this.jdbcTemplate, sqlScript, sqlStatement, config));
                    continue;
                }
                results.add(this.executeStatement(this.jdbcTemplate, sqlScript, sqlStatement, config));
            }
        }
        if (this.batch) {
            results.add(this.executeBatch(this.jdbcTemplate, sqlScript, batchStatements, config));
        }
        return results;
    }

    protected void logStatementExecution(SqlStatement sqlStatement) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing " + (this.batch && sqlStatement.isBatchable() ? "batchable " : "") + "SQL: " + sqlStatement.getSql());
        }
    }

    private Results executeBatch(JdbcTemplate jdbcTemplate, SqlScript sqlScript, List<SqlStatement> batchStatements, Configuration config) {
        if (batchStatements.isEmpty()) {
            return null;
        }
        LOG.debug("Sending batch of " + batchStatements.size() + " statements to database ...");
        ArrayList<String> sqlBatch = new ArrayList<String>();
        for (SqlStatement sqlStatement : batchStatements) {
            try {
                this.handleEachMigrateOrUndoStatementCallback(Event.BEFORE_EACH_UNDO_STATEMENT, Event.BEFORE_EACH_MIGRATE_STATEMENT, sqlStatement.getSql() + sqlStatement.getDelimiter(), null, null);
            }
            catch (FlywayBlockStatementExecutionException e) {
                LOG.debug("Statement on line " + sqlStatement.getLineNumber() + " + skipped due to " + e.getMessage());
                continue;
            }
            sqlBatch.add(sqlStatement.getSql());
        }
        Results results = jdbcTemplate.executeBatch(sqlBatch, config);
        if (results.getException() != null) {
            for (int i = 0; i < results.getResults().size(); ++i) {
                SqlStatement sqlStatement = batchStatements.get(i);
                long updateCount = results.getResults().get(i).updateCount();
                if (updateCount == -3L) {
                    this.handleEachMigrateOrUndoStatementCallback(Event.AFTER_EACH_UNDO_STATEMENT_ERROR, Event.AFTER_EACH_MIGRATE_STATEMENT_ERROR, sqlStatement.getSql() + sqlStatement.getDelimiter(), results.getWarnings(), results.getErrors());
                    this.handleException(results, sqlScript, batchStatements.get(i), config);
                    continue;
                }
                if (updateCount == -2L) continue;
                this.handleEachMigrateOrUndoStatementCallback(Event.AFTER_EACH_UNDO_STATEMENT, Event.AFTER_EACH_MIGRATE_STATEMENT, sqlStatement.getSql() + sqlStatement.getDelimiter(), results.getWarnings(), results.getErrors());
                this.handleUpdateCount(updateCount);
            }
            this.handleException(results, sqlScript, batchStatements.get(0), config);
            return results;
        }
        for (int i = 0; i < results.getResults().size(); ++i) {
            SqlStatement sqlStatement = batchStatements.get(i);
            this.handleEachMigrateOrUndoStatementCallback(Event.AFTER_EACH_UNDO_STATEMENT, Event.AFTER_EACH_MIGRATE_STATEMENT, sqlStatement.getSql() + sqlStatement.getDelimiter(), results.getWarnings(), results.getErrors());
        }
        this.handleResults(results);
        return results;
    }

    protected Results executeStatement(JdbcTemplate jdbcTemplate, SqlScript sqlScript, SqlStatement sqlStatement, Configuration config) {
        this.logStatementExecution(sqlStatement);
        String sql = sqlStatement.getSql() + sqlStatement.getDelimiter();
        try {
            this.handleEachMigrateOrUndoStatementCallback(Event.BEFORE_EACH_UNDO_STATEMENT, Event.BEFORE_EACH_MIGRATE_STATEMENT, sql, null, null);
        }
        catch (FlywayBlockStatementExecutionException e) {
            LOG.debug("Statement on line " + sqlStatement.getLineNumber() + " + skipped due to " + e.getMessage());
            return null;
        }
        Results results = sqlStatement.execute(jdbcTemplate, this, config);
        if (results.getException() != null) {
            this.handleEachMigrateOrUndoStatementCallback(Event.AFTER_EACH_UNDO_STATEMENT_ERROR, Event.AFTER_EACH_MIGRATE_STATEMENT_ERROR, sql, results.getWarnings(), results.getErrors());
            this.printWarnings(results);
            this.handleException(results, sqlScript, sqlStatement, config);
            return null;
        }
        this.handleEachMigrateOrUndoStatementCallback(Event.AFTER_EACH_UNDO_STATEMENT, Event.AFTER_EACH_MIGRATE_STATEMENT, sql, results.getWarnings(), results.getErrors());
        this.printWarnings(results);
        this.handleResults(results);
        return results;
    }

    protected void handleResults(Results results) {
        for (Result result : results.getResults()) {
            long updateCount = result.updateCount();
            if (updateCount != -1L) {
                this.handleUpdateCount(updateCount);
            }
            this.outputQueryResult(result);
        }
    }

    protected void outputQueryResult(Result result) {
        if (this.outputQueryResults && result.columns() != null && !result.columns().isEmpty()) {
            LOG.info(new AsciiTable(result.columns(), result.data(), true, "", "No rows returned").render());
        }
    }

    private void handleUpdateCount(long updateCount) {
        LOG.debug(updateCount + " row" + StringUtils.pluralizeSuffix(updateCount) + " affected");
    }

    protected void handleException(Results results, SqlScript sqlScript, SqlStatement sqlStatement, Configuration config) {
        throw new FlywaySqlScriptException(sqlScript.getResource(), sqlStatement, results.getException(), config.getCurrentEnvironmentName());
    }

    private void printWarnings(Results results) {
        for (Warning warning : results.getWarnings()) {
            if ("00000".equals(warning.getState())) {
                LOG.info("DB: " + warning.getMessage());
                continue;
            }
            LOG.warn("DB: " + warning.getMessage() + " (SQL State: " + warning.getState() + " - Error Code: " + warning.getCode() + ")");
        }
    }

    private void handleEachMigrateOrUndoStatementCallback(Event eventUndo, Event eventMigrate, String sql, List<Warning> warnings, List<Error> errors) {
        this.callbackExecutor.onEachMigrateOrUndoStatementEvent(eventMigrate, sql, warnings, errors);
    }
}

