/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.CommunityDatabaseType;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.plugin.PluginRegister;

public class DatabaseTypeRegister {
    @Generated
    private static final Log LOG = LogFactory.getLog(DatabaseTypeRegister.class);
    private static final List<DatabaseType> SORTED_DATABASE_TYPES = new PluginRegister().getInstancesOf(DatabaseType.class).stream().sorted().toList();

    public static List<DatabaseType> getDatabaseTypes() {
        return new ArrayList<DatabaseType>(SORTED_DATABASE_TYPES);
    }

    public static DatabaseType getDatabaseTypeForUrl(String url, Configuration configuration) {
        List<DatabaseType> typesAcceptingUrl = DatabaseTypeRegister.getDatabaseTypesForUrl(url, configuration);
        if (typesAcceptingUrl.isEmpty()) {
            throw new FlywayException("No Flyway database plugin found to handle " + DatabaseTypeRegister.redactJdbcUrl(url, typesAcceptingUrl) + ". See https://rd.gt/423f9a6 for troubleshooting");
        }
        return typesAcceptingUrl.get(0);
    }

    public static List<DatabaseType> getDatabaseTypesForUrl(String url, Configuration configuration) {
        List<DatabaseType> typesAcceptingUrl = SORTED_DATABASE_TYPES.stream().filter(type -> configuration == null || configuration.isCommunityDBSupportEnabled() || !(type instanceof CommunityDatabaseType)).filter(type -> type.handlesJDBCUrl(url)).toList();
        if (typesAcceptingUrl.size() > 1) {
            String typeNames = String.join((CharSequence)",", typesAcceptingUrl.stream().map(DatabaseType::getName).toList());
            LOG.debug("Multiple databases found that handle url '" + DatabaseTypeRegister.redactJdbcUrl(url, typesAcceptingUrl) + "': " + typeNames);
        }
        return typesAcceptingUrl;
    }

    public static DatabaseType getDatabaseTypeForEngineName(String engineName, Configuration configuration) {
        return SORTED_DATABASE_TYPES.stream().filter(type -> configuration == null || configuration.isCommunityDBSupportEnabled() || !(type instanceof CommunityDatabaseType)).filter(type -> type.getSupportedEngines().stream().anyMatch(engineName::equalsIgnoreCase)).findFirst().orElseThrow(() -> new FlywayException("No Flyway database plugin found to handle " + engineName + " engine. See https://rd.gt/423f9a6 for troubleshooting"));
    }

    public static String redactJdbcUrl(String url) {
        return DatabaseTypeRegister.redactJdbcUrl(url, (Configuration)null);
    }

    public static String redactJdbcUrl(String url, Configuration configuration) {
        List<DatabaseType> types = DatabaseTypeRegister.getDatabaseTypesForUrl(url, configuration);
        return DatabaseTypeRegister.redactJdbcUrl(url, types);
    }

    public static String redactJdbcUrl(String url, Collection<? extends DatabaseType> types) {
        if (types.isEmpty()) {
            url = DatabaseTypeRegister.redactJdbcUrl(url, BaseDatabaseType.getDefaultJDBCCredentialsPattern());
        } else {
            for (DatabaseType databaseType : types) {
                List<Pattern> dbPatterns = databaseType.getJDBCCredentialsPatterns();
                if (dbPatterns == null || dbPatterns.isEmpty()) continue;
                for (Pattern dbPattern : dbPatterns) {
                    url = DatabaseTypeRegister.redactJdbcUrl(url, dbPattern);
                }
            }
        }
        return url;
    }

    private static String redactJdbcUrl(String url, Pattern pattern) {
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            String password = matcher.group(1);
            return url.replace(password, "********");
        }
        return url;
    }

    public static DatabaseType getDatabaseTypeForConnection(Connection connection, Configuration configuration) {
        DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData(connection);
        String databaseProductName = JdbcUtils.getDatabaseProductName(databaseMetaData);
        String databaseProductVersion = JdbcUtils.getDatabaseProductVersion(databaseMetaData);
        return SORTED_DATABASE_TYPES.stream().filter(type -> configuration == null || configuration.isCommunityDBSupportEnabled() || !(type instanceof CommunityDatabaseType)).filter(type -> type.handlesDatabaseProductNameAndVersion(databaseProductName, databaseProductVersion, connection)).findFirst().orElseThrow(() -> new FlywayException("Unsupported Database: " + databaseProductName));
    }
}

