/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.exception.sqlExceptions.FlywaySqlUnableToConnectToDbException;
import org.flywaydb.core.internal.strategy.BackoffStrategy;
import org.flywaydb.core.internal.util.ExceptionUtils;

public class JdbcUtils {
    private static final Log LOG = LogFactory.getLog(JdbcUtils.class);

    public static Connection openConnection(DataSource dataSource, int connectRetries, int connectRetriesInterval) throws FlywayException {
        BackoffStrategy backoffStrategy = new BackoffStrategy(1, 2, connectRetriesInterval);
        Properties systemProperties = System.getProperties();
        if (!systemProperties.containsKey("polyglot.engine.WarnInterpreterOnly")) {
            systemProperties.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
        }
        int retries = 0;
        while (true) {
            try {
                return dataSource.getConnection();
            }
            catch (SQLException sqlException) {
                FlywaySqlException.throwFlywayExceptionIfPossible(sqlException, dataSource);
                if (++retries > connectRetries) {
                    throw new FlywaySqlUnableToConnectToDbException(sqlException, dataSource);
                }
                Throwable rootCause = ExceptionUtils.getRootCause(sqlException);
                String message = "Connection error: " + sqlException.getMessage();
                if (rootCause != null && rootCause != sqlException && rootCause.getMessage() != null) {
                    message = message + "\n(Caused by " + rootCause.getMessage() + ")";
                }
                LOG.warn(message + "\nRetrying in " + backoffStrategy.peek() + " sec...");
                try {
                    Thread.sleep((long)backoffStrategy.next() * 1000L);
                }
                catch (InterruptedException e1) {
                    throw new FlywaySqlUnableToConnectToDbException(sqlException, dataSource);
                }
            }
        }
    }

    public static void closeConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.isClosed()) {
                connection.close();
            }
        }
        catch (Exception e) {
            LOG.error("Error while closing database Connection: " + e.getMessage(), e);
        }
    }

    public static void closeStatement(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            LOG.error("Error while closing JDBC Statement", e);
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            LOG.error("Error while closing JDBC ResultSet", e);
        }
    }

    public static DatabaseMetaData getDatabaseMetaData(Connection connection) {
        DatabaseMetaData databaseMetaData;
        try {
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to read database connection metadata: " + e.getMessage(), e);
        }
        if (databaseMetaData == null) {
            throw new FlywayException("Unable to read database connection metadata while it is null!");
        }
        return databaseMetaData;
    }

    public static String getDatabaseProductName(DatabaseMetaData databaseMetaData) {
        try {
            String databaseProductName = databaseMetaData.getDatabaseProductName();
            if (databaseProductName == null) {
                throw new FlywayException("Unable to determine database. Product name is null.");
            }
            return databaseProductName + " " + databaseMetaData.getDatabaseMajorVersion() + "." + databaseMetaData.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error while determining database product name", e);
        }
    }

    public static String getDatabaseProductVersion(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error while determining database product version", e);
        }
    }

    public static String getDatabaseVersion(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getDatabaseMajorVersion() + "." + databaseMetaData.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error while determining database version", e);
        }
    }

    private JdbcUtils() {
    }
}

