/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration;

import java.io.File;
import java.util.Locale;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.experimental.ExperimentalModeUtils;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class ConfigurationValidator {
    public void validate(Configuration configuration) {
        if (configuration.isBatch() && configuration.getErrorOverrides().length > 0) {
            throw new FlywayException("flyway.batch configuration option is incompatible with flyway.errorOverrides.\nIt is impossible to intercept the errors in a batch process.\nSet flyway.batch to false, or remove the error overrides.", CoreErrorCode.CONFIGURATION);
        }
        if (ExperimentalModeUtils.isExperimentalModeActivated() && !StringUtils.hasText(configuration.getUrl())) {
            String errorMessage = "Unable to connect to the database. A URL must be configured to use Experimental Mode!";
            throw new FlywayException(errorMessage, CoreErrorCode.CONFIGURATION);
        }
        if (configuration.getDataSource() == null && ExperimentalModeUtils.canCreateDataSource(configuration)) {
            Object errorMessage = "Unable to connect to the database. Configure the url, user and password!";
            if (new File(ClassUtils.getInstallDir(ConfigurationValidator.class) + "/conf/flyway.toml.example").exists()) {
                errorMessage = (String)errorMessage + " Refer to the flyway.toml.example file in the /conf folder in the installation directory.";
            }
            throw new FlywayException((String)errorMessage, CoreErrorCode.CONFIGURATION);
        }
        for (String key : configuration.getPlaceholders().keySet()) {
            if (!key.toLowerCase(Locale.ENGLISH).startsWith("flyway" + configuration.getPlaceholderSeparator())) continue;
            throw new FlywayException("Invalid placeholder ('flyway" + configuration.getPlaceholderSeparator() + "' prefix is reserved): " + key);
        }
    }
}

