/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.flywaydb.core.FlywayExecutor;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.exception.FlywayValidateException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.BaselineResult;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.api.pattern.ValidatePattern;
import org.flywaydb.core.experimental.ExperimentalModeUtils;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.extensibility.EventTelemetryModel;
import org.flywaydb.core.extensibility.VerbExtension;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.command.DbBaseline;
import org.flywaydb.core.internal.command.DbInfo;
import org.flywaydb.core.internal.command.DbMigrate;
import org.flywaydb.core.internal.command.DbRepair;
import org.flywaydb.core.internal.command.DbSchemas;
import org.flywaydb.core.internal.command.DbValidate;
import org.flywaydb.core.internal.command.clean.DbClean;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.logging.PreviewFeatureWarning;
import org.flywaydb.core.internal.resolver.CompositeMigrationResolver;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.CommandExtensionUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class Flyway {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private final ClassicConfiguration configuration;
    private final FlywayExecutor flywayExecutor;
    @Deprecated
    private FlywayTelemetryManager flywayTelemetryManager;

    public static FluentConfiguration configure() {
        return new FluentConfiguration();
    }

    public static FluentConfiguration configure(ClassLoader classLoader) {
        return new FluentConfiguration(classLoader);
    }

    public Flyway(Configuration configuration) {
        this.configuration = new ClassicConfiguration(configuration);
        List<Callback> callbacks = this.configuration.loadCallbackLocation("db/callback", false);
        if (!callbacks.isEmpty()) {
            this.configuration.setCallbacks(callbacks.toArray(new Callback[0]));
        }
        this.flywayExecutor = new FlywayExecutor(this.configuration);
        LogFactory.setConfiguration(this.configuration);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public <T extends ConfigurationExtension> T getConfigurationExtension(Class<T> configClass) {
        return (T)((ConfigurationExtension)this.getConfiguration().getPluginRegister().getPlugin(configClass));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MigrateResult migrate() throws FlywayException {
        if (ExperimentalModeUtils.canUseExperimentalMode(this.configuration, "migrate")) {
            PreviewFeatureWarning.logPreviewFeature("ExperimentalMigrate");
            Optional<VerbExtension> verb = this.configuration.getPluginRegister().getPlugins(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("migrate")).findFirst();
            if (verb.isPresent()) {
                return (MigrateResult)verb.get().executeVerb(this.configuration);
            }
            LOG.warn("Experimental mode for migrate is set but no verb is present");
        }
        EventTelemetryModel telemetryModel = new EventTelemetryModel("migrate", this.flywayTelemetryManager);
        try {
            MigrateResult migrateResult = this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
                if (this.configuration.isValidateOnMigrate()) {
                    ArrayList<ValidatePattern> ignorePatterns = new ArrayList<ValidatePattern>(Arrays.asList(this.configuration.getIgnoreMigrationPatterns()));
                    ignorePatterns.add(ValidatePattern.fromPattern("*:pending"));
                    ValidateResult validateResult = this.doValidate(database, migrationResolver, schemaHistory, defaultSchema, schemas, callbackExecutor, ignorePatterns.toArray(new ValidatePattern[0]));
                    if (!validateResult.validationSuccessful) {
                        throw new FlywayValidateException(validateResult.errorDetails, validateResult.getAllErrorMessages());
                    }
                }
                if (this.configuration.isCreateSchemas()) {
                    new DbSchemas(database, schemas, schemaHistory, callbackExecutor).create(false);
                } else if (!defaultSchema.exists()) {
                    LOG.warn("The configuration option 'createSchemas' is false.\nHowever, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee https://documentation.red-gate.com/fd/migrations-184127470.html");
                }
                if (!schemaHistory.exists()) {
                    ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                    for (Schema schema : schemas) {
                        if (!schema.exists() || schema.empty()) continue;
                        nonEmptySchemas.add(schema);
                    }
                    if (!nonEmptySchemas.isEmpty() && !this.configuration.isSkipExecutingMigrations()) {
                        if (this.configuration.isBaselineOnMigrate()) {
                            this.doBaseline(schemaHistory, callbackExecutor, database);
                        } else if (!schemaHistory.exists()) {
                            throw new FlywayException("Found non-empty schema(s) " + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + " but no schema history table. Use baseline() or set baselineOnMigrate to true to initialize the schema history table.", CoreErrorCode.NON_EMPTY_SCHEMA_WITHOUT_SCHEMA_HISTORY_TABLE);
                        }
                    }
                    schemaHistory.create(false);
                }
                MigrateResult result = new DbMigrate(database, schemaHistory, defaultSchema, migrationResolver, this.configuration, callbackExecutor).migrate();
                callbackExecutor.onOperationFinishEvent(Event.AFTER_MIGRATE_OPERATION_FINISH, result);
                return result;
            }, true, this.flywayTelemetryManager);
            return migrateResult;
        }
        catch (Exception e) {
            telemetryModel.setException(e);
            throw e;
        }
        finally {
            try {
                telemetryModel.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public MigrationInfoService info() {
        if (ExperimentalModeUtils.canUseExperimentalMode(this.configuration, "info")) {
            PreviewFeatureWarning.logPreviewFeature("ExperimentalInfo");
            Optional<VerbExtension> verb = this.configuration.getPluginRegister().getPlugins(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("info")).findFirst();
            if (verb.isPresent()) {
                return (MigrationInfoService)verb.get().executeVerb(this.configuration);
            }
            LOG.warn("Experimental mode for info is set but no verb is present");
        }
        return this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
            MigrationInfoService migrationInfoService = new DbInfo(migrationResolver, schemaHistory, this.configuration, database, callbackExecutor, schemas).info();
            callbackExecutor.onOperationFinishEvent(Event.AFTER_INFO_OPERATION_FINISH, migrationInfoService.getInfoResult());
            return migrationInfoService;
        }, true, this.flywayTelemetryManager);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CleanResult clean() {
        if (ExperimentalModeUtils.canUseExperimentalMode(this.configuration, "clean")) {
            PreviewFeatureWarning.logPreviewFeature("ExperimentalClean");
            Optional<VerbExtension> verb = this.configuration.getPluginRegister().getPlugins(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("clean")).findFirst();
            if (verb.isPresent()) {
                return (CleanResult)verb.get().executeVerb(this.configuration);
            }
            LOG.warn("Experimental mode for clean is set but no verb is present");
        }
        EventTelemetryModel telemetryModel = new EventTelemetryModel("clean", this.flywayTelemetryManager);
        try {
            CleanResult cleanResult = this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
                CleanResult cleanResult = this.doClean(database, schemaHistory, defaultSchema, schemas, callbackExecutor);
                callbackExecutor.onOperationFinishEvent(Event.AFTER_CLEAN_OPERATION_FINISH, cleanResult);
                return cleanResult;
            }, false, this.flywayTelemetryManager);
            return cleanResult;
        }
        catch (Exception e) {
            telemetryModel.setException(e);
            throw e;
        }
        finally {
            try {
                telemetryModel.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public void validate() throws FlywayException {
        ValidateResult validateResult = this.validateWithResult();
        if (!validateResult.validationSuccessful) {
            throw new FlywayValidateException(validateResult.errorDetails, validateResult.getAllErrorMessages());
        }
    }

    public ValidateResult validateWithResult() throws FlywayException {
        if (ExperimentalModeUtils.canUseExperimentalMode(this.configuration, "validate")) {
            PreviewFeatureWarning.logPreviewFeature("ExperimentalValidate");
            Optional<VerbExtension> verb = this.configuration.getPluginRegister().getPlugins(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("validate")).findFirst();
            if (verb.isPresent()) {
                return (ValidateResult)verb.get().executeVerb(this.configuration);
            }
            LOG.warn("Experimental mode for validate is set but no verb is present");
        }
        return this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
            ValidateResult validateResult = this.doValidate(database, migrationResolver, schemaHistory, defaultSchema, schemas, callbackExecutor, this.configuration.getIgnoreMigrationPatterns());
            callbackExecutor.onOperationFinishEvent(Event.AFTER_VALIDATE_OPERATION_FINISH, validateResult);
            return validateResult;
        }, true, this.flywayTelemetryManager);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaselineResult baseline() throws FlywayException {
        if (ExperimentalModeUtils.canUseExperimentalMode(this.configuration, "baseline")) {
            PreviewFeatureWarning.logPreviewFeature("ExperimentalBaseline");
            Optional<VerbExtension> verb = this.configuration.getPluginRegister().getPlugins(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("baseline")).findFirst();
            if (verb.isPresent()) {
                return (BaselineResult)verb.get().executeVerb(this.configuration);
            }
            LOG.warn("Experimental mode for baseline is set but no verb is present");
        }
        EventTelemetryModel telemetryModel = new EventTelemetryModel("baseline", this.flywayTelemetryManager);
        try {
            BaselineResult baselineResult = this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
                if (this.configuration.isCreateSchemas()) {
                    new DbSchemas(database, schemas, schemaHistory, callbackExecutor).create(true);
                } else {
                    LOG.warn("The configuration option 'createSchemas' is false.\nEven though Flyway is configured not to create any schemas, the schema history table still needs a schema to reside in.\nYou must manually create a schema for the schema history table to reside in.\nSee https://documentation.red-gate.com/fd/migrations-184127470.html");
                }
                BaselineResult baselineResult = this.doBaseline(schemaHistory, callbackExecutor, database);
                callbackExecutor.onOperationFinishEvent(Event.AFTER_BASELINE_OPERATION_FINISH, baselineResult);
                return baselineResult;
            }, false, this.flywayTelemetryManager);
            return baselineResult;
        }
        catch (Exception e) {
            telemetryModel.setException(e);
            throw e;
        }
        finally {
            try {
                telemetryModel.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RepairResult repair() throws FlywayException {
        if (ExperimentalModeUtils.canUseExperimentalMode(this.configuration, "repair")) {
            PreviewFeatureWarning.logPreviewFeature("ExperimentalRepair");
            Optional<VerbExtension> verb = this.configuration.getPluginRegister().getPlugins(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("repair")).findFirst();
            if (verb.isPresent()) {
                return (RepairResult)verb.get().executeVerb(this.configuration);
            }
            LOG.warn("Experimental mode for repair is set but no verb is present");
        }
        EventTelemetryModel telemetryModel = new EventTelemetryModel("repair", this.flywayTelemetryManager);
        try {
            RepairResult repairResult = this.flywayExecutor.execute((migrationResolver, schemaHistory, database, defaultSchema, schemas, callbackExecutor, statementInterceptor) -> {
                RepairResult repairResult = new DbRepair(database, migrationResolver, schemaHistory, callbackExecutor, this.configuration).repair();
                callbackExecutor.onOperationFinishEvent(Event.AFTER_REPAIR_OPERATION_FINISH, repairResult);
                return repairResult;
            }, true, this.flywayTelemetryManager);
            return repairResult;
        }
        catch (Exception e) {
            telemetryModel.setException(e);
            throw e;
        }
        finally {
            try {
                telemetryModel.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public OperationResult undo() throws FlywayException {
        if (ExperimentalModeUtils.canUseExperimentalMode(this.configuration, "undo")) {
            PreviewFeatureWarning.logPreviewFeature("ExperimentalUndo");
            Optional<VerbExtension> verb = this.configuration.getPluginRegister().getPlugins(VerbExtension.class).stream().filter(verbExtension -> verbExtension.handlesVerb("undo")).findFirst();
            if (verb.isPresent()) {
                return (OperationResult)verb.get().executeVerb(this.configuration);
            }
            LOG.warn("Experimental mode for undo is set but no verb is present");
        }
        try {
            return this.runCommand("undo", Collections.emptyList());
        }
        catch (FlywayException e) {
            if (e.getMessage().startsWith("No command extension found")) {
                throw new FlywayException("The command 'undo' was not recognized. Make sure you have added 'flyway-proprietary' as a dependency.", e);
            }
            throw e;
        }
    }

    private OperationResult runCommand(String command, List<String> flags) {
        return CommandExtensionUtils.runCommandExtension(this.configuration, command, flags, null);
    }

    private CleanResult doClean(Database database, SchemaHistory schemaHistory, Schema defaultSchema, Schema[] schemas, CallbackExecutor callbackExecutor) {
        return new DbClean(database, schemaHistory, defaultSchema, schemas, callbackExecutor, this.configuration).clean();
    }

    private ValidateResult doValidate(Database database, CompositeMigrationResolver migrationResolver, SchemaHistory schemaHistory, Schema defaultSchema, Schema[] schemas, CallbackExecutor callbackExecutor, ValidatePattern[] ignorePatterns) {
        ValidateResult validateResult = new DbValidate(database, schemaHistory, defaultSchema, migrationResolver, this.configuration, callbackExecutor, ignorePatterns).validate();
        if (this.configuration.isCleanOnValidationError()) {
            throw new FlywayException("cleanOnValidationError has been removed");
        }
        return validateResult;
    }

    private BaselineResult doBaseline(SchemaHistory schemaHistory, CallbackExecutor callbackExecutor, Database database) {
        return new DbBaseline(schemaHistory, this.configuration.getBaselineVersion(), this.configuration.getBaselineDescription(), callbackExecutor, database).baseline();
    }

    @Deprecated
    public void setFlywayTelemetryManager(FlywayTelemetryManager flywayTelemetryManager) {
        this.flywayTelemetryManager = flywayTelemetryManager;
    }
}

