/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental.migration;

import java.util.List;
import java.util.Objects;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.experimental.migration.MigrationTypeResolver;
import org.flywaydb.core.extensibility.MigrationType;

public class CompositeMigrationTypeResolver
implements MigrationTypeResolver {
    @Override
    public MigrationType resolveMigrationType(String filename, Configuration configuration) {
        List<MigrationTypeResolver> plugins = configuration.getPluginRegister().getPlugins(MigrationTypeResolver.class);
        return plugins.stream().map(plugin -> plugin.resolveMigrationType(filename, configuration)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public MigrationType resolveMigrationTypeFromName(String name, Configuration configuration) {
        List<MigrationTypeResolver> plugins = configuration.getPluginRegister().getPlugins(MigrationTypeResolver.class);
        return plugins.stream().map(plugin -> {
            try {
                return plugin.resolveMigrationTypeFromName(name, configuration);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

